/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.service;

import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.discovery.AppInfo;
import com.alibaba.csp.sentinel.dashboard.discovery.AppManagement;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterClientInfoVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.ClusterGroupEntity;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.request.ClusterClientModifyRequest;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.request.ClusterServerModifyRequest;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterClientStateVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterStateSimpleEntity;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterUniversalStatePairVO;
import com.alibaba.csp.sentinel.dashboard.domain.cluster.state.ClusterUniversalStateVO;
import com.alibaba.csp.sentinel.dashboard.util.AsyncUtils;
import com.alibaba.csp.sentinel.dashboard.util.ClusterEntityUtils;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusterConfigService {
    @Autowired
    private SentinelApiClient sentinelApiClient;
    @Autowired
    private AppManagement appManagement;

    public CompletableFuture<Void> modifyClusterClientConfig(ClusterClientModifyRequest request) {
        if (this.notClientRequestValid(request)) {
            throw new IllegalArgumentException("Invalid request");
        }
        String app = request.getApp();
        String ip = request.getIp();
        int port = request.getPort();
        return this.sentinelApiClient.modifyClusterClientConfig(app, ip, port, request.getClientConfig()).thenCompose(v -> this.sentinelApiClient.modifyClusterMode(ip, port, 0));
    }

    private boolean notClientRequestValid(ClusterClientModifyRequest request) {
        ClusterClientConfig config = request.getClientConfig();
        return config == null || StringUtil.isEmpty((String)config.getServerHost()) || config.getServerPort() == null || config.getServerPort() <= 0 || config.getRequestTimeout() == null || config.getRequestTimeout() <= 0;
    }

    public CompletableFuture<Void> modifyClusterServerConfig(ClusterServerModifyRequest request) {
        ServerTransportConfig transportConfig = request.getTransportConfig();
        ServerFlowConfig flowConfig = request.getFlowConfig();
        Set<String> namespaceSet = request.getNamespaceSet();
        if (this.invalidTransportConfig(transportConfig)) {
            throw new IllegalArgumentException("Invalid transport config in request");
        }
        if (this.invalidFlowConfig(flowConfig)) {
            throw new IllegalArgumentException("Invalid flow config in request");
        }
        if (namespaceSet == null) {
            throw new IllegalArgumentException("namespace set cannot be null");
        }
        String app = request.getApp();
        String ip = request.getIp();
        int port = request.getPort();
        return ((CompletableFuture)((CompletableFuture)this.sentinelApiClient.modifyClusterServerNamespaceSet(app, ip, port, namespaceSet).thenCompose(v -> this.sentinelApiClient.modifyClusterServerTransportConfig(app, ip, port, transportConfig))).thenCompose(v -> this.sentinelApiClient.modifyClusterServerFlowConfig(app, ip, port, flowConfig))).thenCompose(v -> this.sentinelApiClient.modifyClusterMode(ip, port, 1));
    }

    public CompletableFuture<List<ClusterUniversalStatePairVO>> getClusterUniversalState(String app) {
        if (StringUtil.isBlank((String)app)) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("app cannot be empty"));
        }
        AppInfo appInfo = this.appManagement.getDetailApp(app);
        if (appInfo == null || appInfo.getMachines() == null) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        List futures = appInfo.getMachines().stream().filter(e -> e.isHealthy()).map(machine -> this.getClusterUniversalState(app, machine.getIp(), machine.getPort()).thenApply(e -> new ClusterUniversalStatePairVO(machine.getIp(), machine.getPort(), (ClusterUniversalStateVO)e))).collect(Collectors.toList());
        return AsyncUtils.sequenceSuccessFuture(futures);
    }

    public CompletableFuture<ClusterGroupEntity> getClusterUniversalStateForAppMachine(String app, String machineId) {
        if (StringUtil.isBlank((String)app)) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("app cannot be empty"));
        }
        AppInfo appInfo = this.appManagement.getDetailApp(app);
        if (appInfo == null || appInfo.getMachines() == null) {
            return AsyncUtils.newFailedFuture(new IllegalArgumentException("app does not have machines"));
        }
        boolean machineOk = appInfo.getMachines().stream().filter(e -> e.isHealthy()).map(e -> e.getIp() + '@' + e.getPort()).anyMatch(e -> e.equals(machineId));
        if (!machineOk) {
            return AsyncUtils.newFailedFuture(new IllegalStateException("machine does not exist or disconnected"));
        }
        return ((CompletableFuture)this.getClusterUniversalState(app).thenApply(ClusterEntityUtils::wrapToClusterGroup)).thenCompose(e -> e.stream().filter(e1 -> e1.getMachineId().equals(machineId)).findAny().map(CompletableFuture::completedFuture).orElse(AsyncUtils.newFailedFuture(new IllegalStateException("not a server: " + machineId))));
    }

    public CompletableFuture<ClusterUniversalStateVO> getClusterUniversalState(String app, String ip, int port) {
        return ((CompletableFuture)((CompletableFuture)this.sentinelApiClient.fetchClusterMode(ip, port).thenApply(e -> new ClusterUniversalStateVO().setStateInfo((ClusterStateSimpleEntity)e))).thenCompose(vo -> {
            if (vo.getStateInfo().getClientAvailable().booleanValue()) {
                return this.sentinelApiClient.fetchClusterClientInfoAndConfig(ip, port).thenApply(cc -> vo.setClient(new ClusterClientStateVO().setClientConfig((ClusterClientInfoVO)cc)));
            }
            return CompletableFuture.completedFuture(vo);
        })).thenCompose(vo -> {
            if (vo.getStateInfo().getServerAvailable().booleanValue()) {
                return this.sentinelApiClient.fetchClusterServerBasicInfo(ip, port).thenApply(vo::setServer);
            }
            return CompletableFuture.completedFuture(vo);
        });
    }

    private boolean invalidTransportConfig(ServerTransportConfig transportConfig) {
        return transportConfig == null || transportConfig.getPort() == null || transportConfig.getPort() <= 0 || transportConfig.getIdleSeconds() == null || transportConfig.getIdleSeconds() <= 0;
    }

    private boolean invalidFlowConfig(ServerFlowConfig flowConfig) {
        return flowConfig == null || flowConfig.getSampleCount() == null || flowConfig.getSampleCount() <= 0 || flowConfig.getIntervalMs() == null || flowConfig.getIntervalMs() <= 0 || flowConfig.getIntervalMs() % flowConfig.getSampleCount() != 0 || flowConfig.getMaxAllowedQps() == null || flowConfig.getMaxAllowedQps() < 0.0;
    }
}

