/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.discovery;

import com.alibaba.csp.sentinel.dashboard.config.DashboardConfig;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Objects;

public class MachineInfo
implements Comparable<MachineInfo> {
    private String app = "";
    private Integer appType = 0;
    private String hostname = "";
    private String ip = "";
    private Integer port = -1;
    private long lastHeartbeat;
    private long heartbeatVersion;
    private String version;

    public static MachineInfo of(String app, String ip, Integer port) {
        MachineInfo machineInfo = new MachineInfo();
        machineInfo.setApp(app);
        machineInfo.setIp(ip);
        machineInfo.setPort(port);
        return machineInfo;
    }

    public String toHostPort() {
        return this.ip + ":" + this.port;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Integer getAppType() {
        return this.appType;
    }

    public void setAppType(Integer appType) {
        this.appType = appType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public long getHeartbeatVersion() {
        return this.heartbeatVersion;
    }

    public void setHeartbeatVersion(long heartbeatVersion) {
        this.heartbeatVersion = heartbeatVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public MachineInfo setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isHealthy() {
        long delta = System.currentTimeMillis() - this.lastHeartbeat;
        return delta < (long)DashboardConfig.getUnhealthyMachineMillis();
    }

    public boolean isDead() {
        if (DashboardConfig.getAutoRemoveMachineMillis() > 0) {
            long delta = System.currentTimeMillis() - this.lastHeartbeat;
            return delta > (long)DashboardConfig.getAutoRemoveMachineMillis();
        }
        return false;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(long lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    @Override
    public int compareTo(MachineInfo o) {
        if (this == o) {
            return 0;
        }
        if (!this.port.equals(o.getPort())) {
            return this.port.compareTo(o.getPort());
        }
        if (!StringUtil.equals((String)this.app, (String)o.getApp())) {
            return this.app.compareToIgnoreCase(o.getApp());
        }
        return this.ip.compareToIgnoreCase(o.getIp());
    }

    public String toString() {
        return "MachineInfo {" + "app='" + this.app + '\'' + ",appType='" + this.appType + '\'' + ", hostname='" + this.hostname + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", heartbeatVersion=" + this.heartbeatVersion + ", lastHeartbeat=" + this.lastHeartbeat + ", version='" + this.version + '\'' + ", healthy=" + this.isHealthy() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MachineInfo)) {
            return false;
        }
        MachineInfo that = (MachineInfo)o;
        return Objects.equals(this.app, that.app) && Objects.equals(this.ip, that.ip) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.app, this.ip, this.port);
    }

    public String toLogString() {
        return this.app + "|" + this.ip + "|" + this.port + "|" + this.version;
    }
}

