/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.dashboard.controller;

import com.alibaba.csp.sentinel.dashboard.auth.AuthAction;
import com.alibaba.csp.sentinel.dashboard.auth.AuthService;
import com.alibaba.csp.sentinel.dashboard.client.SentinelApiClient;
import com.alibaba.csp.sentinel.dashboard.datasource.entity.rule.DegradeRuleEntity;
import com.alibaba.csp.sentinel.dashboard.discovery.MachineInfo;
import com.alibaba.csp.sentinel.dashboard.domain.Result;
import com.alibaba.csp.sentinel.dashboard.repository.rule.RuleRepository;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreakerStrategy;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/degrade"})
public class DegradeController {
    private final Logger logger = LoggerFactory.getLogger(DegradeController.class);
    @Autowired
    private RuleRepository<DegradeRuleEntity, Long> repository;
    @Autowired
    private SentinelApiClient sentinelApiClient;

    @GetMapping(value={"/rules.json"})
    @AuthAction(value=AuthService.PrivilegeType.READ_RULE)
    public Result<List<DegradeRuleEntity>> apiQueryMachineRules(String app, String ip, Integer port) {
        if (StringUtil.isEmpty((String)app)) {
            return Result.ofFail(-1, "app can't be null or empty");
        }
        if (StringUtil.isEmpty((String)ip)) {
            return Result.ofFail(-1, "ip can't be null or empty");
        }
        if (port == null) {
            return Result.ofFail(-1, "port can't be null");
        }
        try {
            List<DegradeRuleEntity> rules = this.sentinelApiClient.fetchDegradeRuleOfMachine(app, ip, port);
            rules = this.repository.saveAll(rules);
            return Result.ofSuccess(rules);
        }
        catch (Throwable throwable) {
            this.logger.error("queryApps error:", throwable);
            return Result.ofThrowable(-1, throwable);
        }
    }

    @PostMapping(value={"/rule"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<DegradeRuleEntity> apiAddRule(@RequestBody DegradeRuleEntity entity) {
        Result<DegradeRuleEntity> checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        try {
            entity = this.repository.save(entity);
        }
        catch (Throwable t) {
            this.logger.error("Failed to add new degrade rule, app={}, ip={}", new Object[]{entity.getApp(), entity.getIp(), t});
            return Result.ofThrowable(-1, t);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.warn("Publish degrade rules failed, app={}", (Object)entity.getApp());
        }
        return Result.ofSuccess(entity);
    }

    @PutMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.WRITE_RULE)
    public Result<DegradeRuleEntity> apiUpdateRule(@PathVariable(value="id") Long id, @RequestBody DegradeRuleEntity entity) {
        if (id == null || id <= 0L) {
            return Result.ofFail(-1, "id can't be null or negative");
        }
        DegradeRuleEntity oldEntity = this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofFail(-1, "Degrade rule does not exist, id=" + id);
        }
        entity.setApp(oldEntity.getApp());
        entity.setIp(oldEntity.getIp());
        entity.setPort(oldEntity.getPort());
        entity.setId(oldEntity.getId());
        Result<DegradeRuleEntity> checkResult = this.checkEntityInternal(entity);
        if (checkResult != null) {
            return checkResult;
        }
        entity.setGmtCreate(oldEntity.getGmtCreate());
        entity.setGmtModified(new Date());
        try {
            entity = this.repository.save(entity);
        }
        catch (Throwable t) {
            this.logger.error("Failed to save degrade rule, id={}, rule={}", new Object[]{id, entity, t});
            return Result.ofThrowable(-1, t);
        }
        if (!this.publishRules(entity.getApp(), entity.getIp(), entity.getPort())) {
            this.logger.warn("Publish degrade rules failed, app={}", (Object)entity.getApp());
        }
        return Result.ofSuccess(entity);
    }

    @DeleteMapping(value={"/rule/{id}"})
    @AuthAction(value=AuthService.PrivilegeType.DELETE_RULE)
    public Result<Long> delete(@PathVariable(value="id") Long id) {
        if (id == null) {
            return Result.ofFail(-1, "id can't be null");
        }
        DegradeRuleEntity oldEntity = this.repository.findById(id);
        if (oldEntity == null) {
            return Result.ofSuccess(null);
        }
        try {
            this.repository.delete(id);
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to delete degrade rule, id={}", (Object)id, (Object)throwable);
            return Result.ofThrowable(-1, throwable);
        }
        if (!this.publishRules(oldEntity.getApp(), oldEntity.getIp(), oldEntity.getPort())) {
            this.logger.warn("Publish degrade rules failed, app={}", (Object)oldEntity.getApp());
        }
        return Result.ofSuccess(id);
    }

    private boolean publishRules(String app, String ip, Integer port) {
        List<DegradeRuleEntity> rules = this.repository.findAllByMachine(MachineInfo.of(app, ip, port));
        return this.sentinelApiClient.setDegradeRuleOfMachine(app, ip, port, rules);
    }

    private <R> Result<R> checkEntityInternal(DegradeRuleEntity entity) {
        if (StringUtil.isBlank((String)entity.getApp())) {
            return Result.ofFail(-1, "app can't be blank");
        }
        if (StringUtil.isBlank((String)entity.getIp())) {
            return Result.ofFail(-1, "ip can't be null or empty");
        }
        if (entity.getPort() == null || entity.getPort() <= 0) {
            return Result.ofFail(-1, "invalid port: " + entity.getPort());
        }
        if (StringUtil.isBlank((String)entity.getLimitApp())) {
            return Result.ofFail(-1, "limitApp can't be null or empty");
        }
        if (StringUtil.isBlank((String)entity.getResource())) {
            return Result.ofFail(-1, "resource can't be null or empty");
        }
        Double threshold = entity.getCount();
        if (threshold == null || threshold < 0.0) {
            return Result.ofFail(-1, "invalid threshold: " + threshold);
        }
        Integer recoveryTimeoutSec = entity.getTimeWindow();
        if (recoveryTimeoutSec == null || recoveryTimeoutSec <= 0) {
            return Result.ofFail(-1, "recoveryTimeout should be positive");
        }
        Integer strategy = entity.getGrade();
        if (strategy == null) {
            return Result.ofFail(-1, "circuit breaker strategy cannot be null");
        }
        if (strategy < CircuitBreakerStrategy.SLOW_REQUEST_RATIO.getType() || strategy > 2) {
            return Result.ofFail(-1, "Invalid circuit breaker strategy: " + strategy);
        }
        if (entity.getMinRequestAmount() == null || entity.getMinRequestAmount() <= 0) {
            return Result.ofFail(-1, "Invalid minRequestAmount");
        }
        if (entity.getStatIntervalMs() == null || entity.getStatIntervalMs() <= 0) {
            return Result.ofFail(-1, "Invalid statInterval");
        }
        if (strategy == 0) {
            Double slowRatio = entity.getSlowRatioThreshold();
            if (slowRatio == null) {
                return Result.ofFail(-1, "SlowRatioThreshold is required for slow request ratio strategy");
            }
            if (slowRatio < 0.0 || slowRatio > 1.0) {
                return Result.ofFail(-1, "SlowRatioThreshold should be in range: [0.0, 1.0]");
            }
        } else if (strategy == 1 && threshold > 1.0) {
            return Result.ofFail(-1, "Ratio threshold should be in range: [0.0, 1.0]");
        }
        return null;
    }
}

