/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlParserUtils {
    private static final Log logger = LogFactory.getLog(SqlParserUtils.class);
    public static final Pattern MB_PLACEHOLDER = Pattern.compile("(#\\{[^}]+})|(\\$\\{[^}]+})");
    public static final String MB_PREFIX = "__MB_PARAM_";
    public static final String MB_SUFFIX = "__";
    private static final String QUOTED_INFO_KEY = "__MB__QUOTED_INFO__";
    private static final char ENTRY_SEP = ';';
    private static final char KV_SEP = '=';

    public static String maskMyBatisPlaceholders(String text, Map<String, String> tokenToRaw) {
        return SqlParserUtils.maskMyBatisPlaceholders(text, tokenToRaw, "");
    }

    public static String maskMyBatisPlaceholders(String text, Map<String, String> tokenToRaw, String customMaskKey) {
        logger.debug((Object)("[Mybatis\u66ff\u6362\u5360\u4f4d\u7b26] maskMyBatisPlaceholders: " + text));
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (customMaskKey == null || customMaskKey.isEmpty()) {
            customMaskKey = "";
        }
        Matcher m = MB_PLACEHOLDER.matcher(text);
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        HashMap<CallSite, Boolean> quotedMap = new HashMap<CallSite, Boolean>();
        while (m.find()) {
            boolean adjacentRightQuote;
            int right;
            int left;
            String raw = m.group();
            String token = MB_PREFIX + customMaskKey + idx + MB_SUFFIX;
            int start = m.start();
            int end = m.end();
            for (left = start - 1; left >= 0 && Character.isWhitespace(text.charAt(left)); --left) {
            }
            for (right = end; right < text.length() && Character.isWhitespace(text.charAt(right)); ++right) {
            }
            char leftChar = left >= 0 ? text.charAt(left) : (char)'\u0000';
            char rightChar = right < text.length() ? text.charAt(right) : (char)'\u0000';
            boolean alreadyQuoted = leftChar == '\'' && rightChar == '\'';
            boolean adjacentLeftQuote = start > 0 && text.charAt(start - 1) == '\'';
            boolean bl = adjacentRightQuote = end < text.length() && text.charAt(end) == '\'';
            if (!alreadyQuoted && adjacentLeftQuote && adjacentRightQuote) {
                alreadyQuoted = true;
            }
            quotedMap.put((CallSite)((Object)token), alreadyQuoted);
            tokenToRaw.put(token, raw);
            logger.debug((Object)("[Mybatis\u66ff\u6362\u5360\u4f4d\u7b26] raw=" + raw + ", token=" + token + ", alreadyQuoted=" + alreadyQuoted));
            String replacement = alreadyQuoted ? token : "'" + token + "'";
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            ++idx;
        }
        m.appendTail(sb);
        String masked = sb.toString();
        masked = masked.replaceAll("''(__MB_PARAM_[^']+__)''", "'$1'");
        if (!quotedMap.isEmpty()) {
            StringBuilder serial = new StringBuilder();
            for (Map.Entry e : quotedMap.entrySet()) {
                serial.append((String)e.getKey()).append('=').append((Boolean)e.getValue() != false ? (char)'1' : '0').append(';');
            }
            tokenToRaw.put(QUOTED_INFO_KEY, serial.toString());
        }
        logger.debug((Object)("[Mybatis\u66ff\u6362\u5360\u4f4d\u7b26] \u8f93\u51fa: " + masked));
        return masked;
    }

    public static String restoreMyBatisPlaceholders(String sql, Map<String, String> tokenToRaw) {
        logger.debug((Object)("[Mybatis\u5360\u4f4d\u7b26\u8fd8\u539f] restoreMyBatisPlaceholders: " + sql));
        if (sql == null || tokenToRaw == null || tokenToRaw.isEmpty()) {
            return sql;
        }
        HashMap<String, Boolean> quotedMap = new HashMap<String, Boolean>();
        String quotedSerial = tokenToRaw.get(QUOTED_INFO_KEY);
        if (quotedSerial != null) {
            int pos = 0;
            int len = quotedSerial.length();
            while (pos < len) {
                int kv;
                String entry;
                int sep = quotedSerial.indexOf(59, pos);
                if (sep == -1) {
                    sep = len;
                }
                if (!(entry = quotedSerial.substring(pos, sep).trim()).isEmpty() && (kv = entry.indexOf(61)) > 0) {
                    String k = entry.substring(0, kv);
                    char v = entry.charAt(kv + 1);
                    quotedMap.put(k, v == '1');
                }
                pos = sep + 1;
            }
        }
        String out = sql;
        for (Map.Entry<String, String> e : tokenToRaw.entrySet()) {
            String raw;
            String token = e.getKey();
            if (QUOTED_INFO_KEY.equals(token) || !MB_PLACEHOLDER.matcher(raw = e.getValue()).matches()) continue;
            Boolean wasQuoted = (Boolean)quotedMap.get(token);
            out = wasQuoted != null && wasQuoted != false ? out.replace("'" + token + "'", "'" + raw + "'") : out.replace("'" + token + "'", raw);
            out = out.replace(token, raw);
        }
        logger.debug((Object)("[Mybatis\u5360\u4f4d\u7b26\u8fd8\u539f] restoreMyBatisPlaceholders result: " + out));
        return out;
    }
}

