/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util;

public class SimpleAddWhereHelper {
    public static String addWhereCondition(String sql, String condition) {
        if (sql == null || condition == null || condition.trim().isEmpty()) {
            return sql;
        }
        sql = sql.trim();
        condition = condition.trim();
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        boolean hasWhere = false;
        int wherePos = -1;
        int nestedLevel = 0;
        String sqlLower = sql.toLowerCase();
        for (int i = 0; i < sqlLower.length() - 5; ++i) {
            char c = sqlLower.charAt(i);
            if (c == '(') {
                ++nestedLevel;
                continue;
            }
            if (c == ')') {
                --nestedLevel;
                continue;
            }
            if (nestedLevel != 0 || i + 5 >= sqlLower.length() || !sqlLower.substring(i, i + 5).equals("where") || i != 0 && !Character.isWhitespace(sqlLower.charAt(i - 1)) || i + 5 != sqlLower.length() && !Character.isWhitespace(sqlLower.charAt(i + 5))) continue;
            hasWhere = true;
            wherePos = i;
            break;
        }
        if (hasWhere) {
            int endPos = SimpleAddWhereHelper.findWhereConditionEnd(sql, wherePos + 5);
            return sql.substring(0, endPos) + " AND " + condition + sql.substring(endPos);
        }
        int insertPos = SimpleAddWhereHelper.findWhereInsertPosition(sql);
        StringBuilder result = new StringBuilder();
        result.append(sql.substring(0, insertPos).trim());
        result.append(" WHERE ");
        result.append(condition);
        String remaining = sql.substring(insertPos).trim();
        if (!remaining.isEmpty()) {
            result.append(" ").append(remaining);
        }
        return result.toString();
    }

    public static String addWhereCondition(String sql, String field, Object value, String operator) {
        if (sql == null || field == null || field.trim().isEmpty() || operator == null || operator.trim().isEmpty()) {
            return sql;
        }
        String condition = SimpleAddWhereHelper.buildCondition(field, value, operator);
        return SimpleAddWhereHelper.addWhereCondition(sql, condition);
    }

    private static String buildCondition(String field, Object value, String operator) {
        StringBuilder condition = new StringBuilder();
        condition.append(field).append(" ").append(operator).append(" ");
        if (value == null) {
            condition.append("NULL");
        } else if (value instanceof Number || value instanceof Boolean) {
            condition.append(value);
        } else {
            String strValue = value.toString().replace("'", "''");
            condition.append("'").append(strValue).append("'");
        }
        return condition.toString();
    }

    private static int findWhereConditionEnd(String sql, int startPos) {
        int nestedLevel = 0;
        String sqlLower = sql.toLowerCase();
        for (int i = startPos; i < sqlLower.length(); ++i) {
            char c = sqlLower.charAt(i);
            if (c == '(') {
                ++nestedLevel;
                continue;
            }
            if (c == ')') {
                --nestedLevel;
                continue;
            }
            if (nestedLevel != 0) continue;
            for (String keyword : new String[]{"group by", "having", "order by", "limit"}) {
                if (i + keyword.length() > sqlLower.length() || !sqlLower.regionMatches(i, keyword, 0, keyword.length()) || i != 0 && !Character.isWhitespace(sqlLower.charAt(i - 1)) || i + keyword.length() != sqlLower.length() && !Character.isWhitespace(sqlLower.charAt(i + keyword.length()))) continue;
                return i;
            }
        }
        return sql.length();
    }

    private static int findWhereInsertPosition(String sql) {
        int nestedLevel = 0;
        String sqlLower = sql.toLowerCase();
        int fromPos = -1;
        for (int i = 0; i < sqlLower.length() - 4; ++i) {
            char c = sqlLower.charAt(i);
            if (c == '(') {
                ++nestedLevel;
                continue;
            }
            if (c == ')') {
                --nestedLevel;
                continue;
            }
            if (nestedLevel != 0 || i + 4 >= sqlLower.length() || !sqlLower.regionMatches(i, "from", 0, 4) || i != 0 && !Character.isWhitespace(sqlLower.charAt(i - 1)) || i + 4 != sqlLower.length() && !Character.isWhitespace(sqlLower.charAt(i + 4))) continue;
            fromPos = i + 4;
            break;
        }
        if (fromPos == -1) {
            return sql.length();
        }
        int endPos = SimpleAddWhereHelper.findFromClauseEnd(sql, fromPos);
        int clausePos = Integer.MAX_VALUE;
        nestedLevel = 0;
        for (int i = endPos; i < sqlLower.length(); ++i) {
            char c = sqlLower.charAt(i);
            if (c == '(') {
                ++nestedLevel;
                continue;
            }
            if (c == ')') {
                --nestedLevel;
                continue;
            }
            if (nestedLevel != 0) continue;
            for (String keyword : new String[]{"group by", "having", "order by", "limit"}) {
                if (i + keyword.length() > sqlLower.length() || !sqlLower.regionMatches(i, keyword, 0, keyword.length()) || i != 0 && !Character.isWhitespace(sqlLower.charAt(i - 1)) || i + keyword.length() != sqlLower.length() && !Character.isWhitespace(sqlLower.charAt(i + keyword.length()))) continue;
                clausePos = i;
                break;
            }
            if (clausePos != Integer.MAX_VALUE) break;
        }
        return clausePos != Integer.MAX_VALUE ? clausePos : sql.length();
    }

    private static int findFromClauseEnd(String sql, int startPos) {
        int nestedLevel = 0;
        String sqlLower = sql.toLowerCase();
        for (int i = startPos; i < sqlLower.length(); ++i) {
            char c = sqlLower.charAt(i);
            if (c == '(') {
                ++nestedLevel;
                continue;
            }
            if (c == ')') {
                --nestedLevel;
                continue;
            }
            if (nestedLevel != 0) continue;
            for (String keyword : new String[]{"where", "group by", "having", "order by", "limit"}) {
                if (i + keyword.length() > sqlLower.length() || !sqlLower.regionMatches(i, keyword, 0, keyword.length()) || i != 0 && !Character.isWhitespace(sqlLower.charAt(i - 1)) || i + keyword.length() != sqlLower.length() && !Character.isWhitespace(sqlLower.charAt(i + keyword.length()))) continue;
                return i;
            }
        }
        return sql.length();
    }
}

