/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import java.lang.invoke.StringConcatFactory;
import java.util.Collection;
import java.util.Map;
import org.jeecgframework.poi.exception.excel.ExcelExportException;
import org.jeecgframework.poi.util.PoiFunctionUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;

public final class PoiElUtil {
    public static final String LENGTH = "le:";
    public static final String FOREACH = "fe:";
    public static final String FOREACH_NOT_CREATE = "!fe:";
    public static final String FOREACH_AND_SHIFT = "$fe:";
    public static final String FOREACH_COL = "#fe:";
    public static final String FOREACH_COL_VALUE = "v_fe:";
    public static final String START_STR = "{{";
    public static final String END_STR = "}}";
    public static final String WRAP = "]]";
    public static final String NUMBER_SYMBOL = "n:";
    public static final String FORMAT_DATE = "fd:";
    public static final String FORMAT_NUMBER = "fn:";
    public static final String IF_DELETE = "!if:";
    public static final String EMPTY = "";
    public static final String CONST = "'";
    public static final String NULL = "&NULL&";
    public static final String LEFT_BRACKET = "(";
    public static final String RIGHT_BRACKET = ")";
    public static final String DICT_HANDLER = "dict:";

    private PoiElUtil() {
    }

    public static Object eval(String text, Map<String, Object> map) throws Exception {
        String tempText = new String(text);
        Object obj = PoiElUtil.innerEval(text, map);
        if (tempText.equals(obj.toString())) {
            if (map.containsKey(tempText.split("\\.")[0])) {
                return PoiPublicUtil.getParamsValue(text, map);
            }
            return EMPTY;
        }
        return obj;
    }

    public static Object innerEval(String text, Map<String, Object> map) throws Exception {
        if (text.indexOf("?") != -1 && text.indexOf(":") != -1) {
            return PoiElUtil.trinocular(text, map);
        }
        if (text.indexOf(LENGTH) != -1) {
            return PoiElUtil.length(text, map);
        }
        if (text.indexOf(FORMAT_DATE) != -1) {
            return PoiElUtil.formatDate(text, map);
        }
        if (text.indexOf(FORMAT_NUMBER) != -1) {
            return PoiElUtil.formatNumber(text, map);
        }
        if (text.indexOf(IF_DELETE) != -1) {
            return PoiElUtil.ifDelete(text, map);
        }
        if (text.startsWith(CONST)) {
            return text.replace(CONST, EMPTY);
        }
        return text;
    }

    private static Object ifDelete(String text, Map<String, Object> map) throws Exception {
        text = text.replaceAll("\\s{1,}", " ").trim();
        String[] keys = PoiElUtil.getKey(IF_DELETE, text).split(" ");
        text = text.replace(IF_DELETE, EMPTY);
        return PoiElUtil.isTrue(keys, map);
    }

    private static Boolean isTrue(String[] keys, Map<String, Object> map) throws Exception {
        if (keys.length == 1) {
            String constant = null;
            constant = PoiElUtil.isConstant(keys[0]);
            if (constant != null) {
                return Boolean.valueOf(constant);
            }
            return Boolean.valueOf(PoiPublicUtil.getParamsValue(keys[0], map).toString());
        }
        if (keys.length == 3) {
            if (keys[0] == null || keys[2] == null) {
                return false;
            }
            String first = String.valueOf(PoiElUtil.eval(keys[0], map));
            String second = String.valueOf(PoiElUtil.eval(keys[2], map));
            return PoiFunctionUtil.isTrue(first, keys[1], second);
        }
        throw new ExcelExportException("\u5224\u65ad\u53c2\u6570\u4e0d\u5bf9");
    }

    private static String isConstant(String param) {
        if (param.indexOf(CONST) != -1) {
            return param.replace(CONST, EMPTY);
        }
        return null;
    }

    private static Object formatNumber(String text, Map<String, Object> map) throws Exception {
        String[] key = PoiElUtil.getKey(FORMAT_NUMBER, text).split(";");
        text = text.replace(FORMAT_NUMBER, EMPTY);
        return PoiElUtil.innerEval(PoiElUtil.replacinnerEvalue(text, PoiFunctionUtil.formatNumber(PoiPublicUtil.getParamsValue(key[0], map), key[1])), map);
    }

    private static Object formatDate(String text, Map<String, Object> map) throws Exception {
        String[] key = PoiElUtil.getKey(FORMAT_DATE, text).split(";");
        text = text.replace(FORMAT_DATE, EMPTY);
        return PoiElUtil.innerEval(PoiElUtil.replacinnerEvalue(text, PoiFunctionUtil.formatDate(PoiPublicUtil.getParamsValue(key[0], map), key[1])), map);
    }

    private static Object length(String text, Map<String, Object> map) throws Exception {
        String key = PoiElUtil.getKey(LENGTH, text);
        text = text.replace(LENGTH, EMPTY);
        Object val = PoiPublicUtil.getParamsValue(key, map);
        return PoiElUtil.innerEval(PoiElUtil.replacinnerEvalue(text, PoiFunctionUtil.length(val)), map);
    }

    private static String replacinnerEvalue(String text, Object val) {
        StringBuilder sb = new StringBuilder();
        sb.append(text.substring(0, text.indexOf(LEFT_BRACKET)));
        sb.append(" ");
        sb.append(val);
        sb.append(" ");
        sb.append(text.substring(text.indexOf(RIGHT_BRACKET) + 1, text.length()));
        return sb.toString().trim();
    }

    private static String getKey(String prefix, String text) {
        int leftBracket = 1;
        int rigthBracket = 0;
        int position = 0;
        int index = ((String)text).indexOf(prefix) + prefix.length();
        while (((String)text).charAt(index) == " ".charAt(0)) {
            text = ((String)text).substring(0, index) + ((String)text).substring(index + 1, ((String)text).length());
        }
        for (int i = ((String)text).indexOf((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001("}, (String)prefix))) + prefix.length() + 1; i < ((String)text).length(); ++i) {
            if (((String)text).charAt(i) == LEFT_BRACKET.charAt(0)) {
                ++leftBracket;
            }
            if (((String)text).charAt(i) == RIGHT_BRACKET.charAt(0)) {
                ++rigthBracket;
            }
            if (leftBracket != rigthBracket) continue;
            position = i;
            break;
        }
        return ((String)text).substring(((String)text).indexOf(prefix + LEFT_BRACKET) + 1 + prefix.length(), position).trim();
    }

    public static void main(String[] args) {
        System.out.println(PoiElUtil.getKey(IF_DELETE, "\u6d4b\u8bd5 !if: (\u5c0f\u660e)"));
    }

    private static Object trinocular(String text, Map<String, Object> map) throws Exception {
        text = text.replaceAll("\\s{1,}", " ").trim();
        String testText = text.substring(0, text.indexOf("?"));
        text = text.substring(text.indexOf("?") + 1, text.length()).trim();
        text = PoiElUtil.innerEval(text, map).toString();
        String[] keys = text.split(":");
        Object first = null;
        Object second = null;
        if (keys.length > 2) {
            if (keys[0].trim().contains("?")) {
                Object trinocular = keys[0];
                for (int i = 1; i < keys.length - 1; ++i) {
                    trinocular = (String)trinocular + ":" + keys[i];
                }
                first = PoiElUtil.evalNoParse((String)trinocular, map);
                second = PoiElUtil.evalNoParse(keys[keys.length - 1].trim(), map);
            } else {
                first = PoiElUtil.evalNoParse(keys[0].trim(), map);
                Object trinocular = keys[1];
                for (int i = 2; i < keys.length; ++i) {
                    trinocular = (String)trinocular + ":" + keys[i];
                }
                second = PoiElUtil.evalNoParse((String)trinocular, map);
            }
        } else {
            first = PoiElUtil.evalNoParse(keys[0].trim(), map);
            second = PoiElUtil.evalNoParse(keys[1].trim(), map);
        }
        return PoiElUtil.isTrue(testText.split(" "), map) != false ? first : second;
    }

    public static Object evalNoParse(String text, Map<String, Object> map) throws Exception {
        String tempText = new String(text);
        Object obj = PoiElUtil.innerEval(text, map);
        if (tempText.equals(obj.toString())) {
            if (map.containsKey(tempText.split("\\.")[0])) {
                return PoiPublicUtil.getParamsValue(tempText, map);
            }
            return obj;
        }
        return obj;
    }

    public static String evalFindName(String text, Map<String, Object> map) throws Exception {
        String[] keys = text.split("\\.");
        StringBuilder sb = new StringBuilder().append(keys[0]);
        for (int i = 1; i < keys.length; ++i) {
            sb.append(".").append(keys[i]);
            if (!(PoiElUtil.eval(sb.toString(), map) instanceof Collection)) continue;
            return sb.toString();
        }
        return null;
    }
}

