/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.imports;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.poi.excel.annotation.ExcelTarget;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.entity.params.ExcelCollectionParams;
import org.jeecgframework.poi.excel.entity.params.ExcelImportEntity;
import org.jeecgframework.poi.excel.entity.result.ExcelImportResult;
import org.jeecgframework.poi.excel.entity.result.ExcelVerifyHanlderResult;
import org.jeecgframework.poi.excel.imports.CellValueServer;
import org.jeecgframework.poi.excel.imports.base.ImportBaseService;
import org.jeecgframework.poi.excel.imports.base.ImportFileServiceI;
import org.jeecgframework.poi.excel.imports.verifys.VerifyHandlerServer;
import org.jeecgframework.poi.exception.excel.ExcelImportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelImportEnum;
import org.jeecgframework.poi.util.ExcelUtil;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportServer
extends ImportBaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportServer.class);
    private CellValueServer cellValueServer = new CellValueServer();
    private VerifyHandlerServer verifyHandlerServer = new VerifyHandlerServer();
    private boolean verfiyFail = false;
    private CellStyle errorCellStyle;

    private void addListContinue(Object object, ExcelCollectionParams param, Row row, Map<Integer, String> titlemap, String targetId, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        Collection collection = (Collection)PoiPublicUtil.getMethod(param.getName(), object.getClass()).invoke(object, new Object[0]);
        Object entity = PoiPublicUtil.createObject(param.getType(), targetId);
        boolean isUsed = false;
        for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            String titleString = titlemap.get(i);
            if (!param.getExcelParams().containsKey(titleString)) continue;
            if (param.getExcelParams().get(titleString).getType() == 2) {
                String picId = row.getRowNum() + "_" + i;
                this.saveImage(object, picId, param.getExcelParams(), titleString, pictures, params);
            } else {
                this.saveFieldValue(params, entity, cell, param.getExcelParams(), titleString, row);
            }
            isUsed = true;
        }
        if (isUsed) {
            collection.add(entity);
        }
    }

    private String getKeyValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        Object obj = null;
        switch (cell.getCellTypeEnum()) {
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case FORMULA: {
                obj = cell.getCellFormula();
            }
        }
        return obj == null ? null : obj.toString().trim();
    }

    private String getSaveUrl(ExcelImportEntity excelImportEntity, Object object) throws Exception {
        String url = "";
        if (excelImportEntity.getSaveUrl().equals("upload")) {
            if (excelImportEntity.getMethods() != null && excelImportEntity.getMethods().size() > 0) {
                object = this.getFieldBySomeMethod(excelImportEntity.getMethods(), object);
            }
            url = object.getClass().getName().split("\\.")[object.getClass().getName().split("\\.").length - 1];
            return excelImportEntity.getSaveUrl() + "/" + url.substring(0, url.lastIndexOf("Entity"));
        }
        return excelImportEntity.getSaveUrl();
    }

    private <T> List<T> importExcel(Collection<T> result, Sheet sheet, Class<?> pojoClass, ImportParams params, Map<String, PictureData> pictures) throws Exception {
        ArrayList<Object> collection = new ArrayList<Object>();
        HashMap<String, ExcelImportEntity> excelParams = new HashMap<String, ExcelImportEntity>();
        ArrayList<ExcelCollectionParams> excelCollection = new ArrayList<ExcelCollectionParams>();
        String targetId = null;
        if (!Map.class.equals(pojoClass)) {
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            if (etarget != null) {
                targetId = etarget.value();
            }
            this.getAllExcelField(targetId, fileds, excelParams, excelCollection, pojoClass, null);
        }
        this.ignoreHeaderHandler(excelParams, params);
        Iterator rows = sheet.rowIterator();
        Map<Integer, String> titlemap = this.getTitleMap(sheet, rows, params, excelCollection);
        Set<Integer> columnIndexSet = titlemap.keySet();
        Integer maxColumnIndex = Collections.max(columnIndexSet);
        Integer minColumnIndex = Collections.min(columnIndexSet);
        Row row = null;
        for (int j = 0; j < params.getTitleRows() + params.getHeadRows(); ++j) {
            row = (Row)rows.next();
        }
        Object object = null;
        while (rows.hasNext() && (row == null || sheet.getLastRowNum() - row.getRowNum() > params.getLastOfInvalidRow())) {
            row = (Row)rows.next();
            Cell keyIndexCell = row.getCell(params.getKeyIndex());
            if (excelCollection.size() > 0 && StringUtils.isEmpty((CharSequence)this.getKeyValue(keyIndexCell)) && object != null && !Map.class.equals(pojoClass)) {
                for (ExcelCollectionParams param : excelCollection) {
                    this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
                continue;
            }
            object = PoiPublicUtil.createObject(pojoClass, targetId);
            try {
                int lastCellNum;
                int firstCellNum = row.getFirstCellNum();
                if (firstCellNum > minColumnIndex) {
                    firstCellNum = minColumnIndex;
                }
                if ((lastCellNum = row.getLastCellNum()) < maxColumnIndex + 1) {
                    lastCellNum = maxColumnIndex + 1;
                }
                int le = lastCellNum;
                for (int i = firstCellNum; i < le; ++i) {
                    String picId;
                    Cell cell = row.getCell(i);
                    String titleString = titlemap.get(i);
                    if (!excelParams.containsKey(titleString) && !Map.class.equals(pojoClass)) continue;
                    if (excelParams.get(titleString) != null && ((ExcelImportEntity)excelParams.get(titleString)).getType() == 2) {
                        picId = row.getRowNum() + "_" + i;
                        this.saveImage(object, picId, excelParams, titleString, pictures, params);
                        continue;
                    }
                    if (params.getImageList() != null && params.getImageList().contains(titleString)) {
                        PictureData image;
                        if (pictures == null || (image = pictures.get(picId = row.getRowNum() + "_" + i)) == null) continue;
                        byte[] data = image.getData();
                        params.getDataHanlder().setMapValue((Map)object, titleString, data);
                        continue;
                    }
                    this.saveFieldValue(params, object, cell, excelParams, titleString, row);
                }
                for (ExcelCollectionParams param : excelCollection) {
                    this.addListContinue(object, param, row, titlemap, targetId, pictures, params);
                }
                if (!this.isNotNullObject(pojoClass, object)) continue;
                collection.add(object);
            }
            catch (ExcelImportException e) {
                if (e.getType().equals((Object)ExcelImportEnum.VERIFY_ERROR)) continue;
                throw new ExcelImportException(e.getType(), (Throwable)e);
            }
        }
        return collection;
    }

    private boolean isNotNullObject(Class pojoClass, Object object) {
        try {
            Object flag;
            Method method = pojoClass.getMethod("isNullObject", new Class[0]);
            if (method != null && (flag = method.invoke(object, new Object[0])) != null && Boolean.parseBoolean(flag.toString())) {
                return false;
            }
        }
        catch (NoSuchMethodException e) {
            System.out.println("\u6ca1\u6709\u8be5\u65b9\u6cd5 isNullObject");
        }
        catch (IllegalAccessException e) {
            System.out.println("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u65b9\u6cd5 isNullObject");
        }
        catch (InvocationTargetException e) {
            System.out.println("\u65b9\u6cd5\u8c03\u7528\u5931\u8d25 isNullObject");
        }
        return true;
    }

    private void ignoreHeaderHandler(Map<String, ExcelImportEntity> excelParams, ImportParams params) {
        ArrayList<String> ignoreList = new ArrayList<String>();
        for (String key : excelParams.keySet()) {
            String temp = excelParams.get(key).getGroupName();
            if (temp == null || temp.length() <= 0) continue;
            ignoreList.add(temp);
        }
        params.setIgnoreHeaderList(ignoreList);
    }

    private Map<Integer, String> getTitleMap(Sheet sheet, Iterator<Row> rows, ImportParams params, List<ExcelCollectionParams> excelCollection) throws Exception {
        HashMap<Integer, String> titlemap = new HashMap<Integer, String>();
        Iterator cellTitle = null;
        String collectionName = null;
        Object collectionParams = null;
        Row headRow = null;
        int headBegin = params.getTitleRows();
        int allRowNum = sheet.getPhysicalNumberOfRows();
        while (headRow == null && headBegin < allRowNum) {
            headRow = sheet.getRow(headBegin++);
        }
        if (headRow == null) {
            throw new Exception("\u4e0d\u8bc6\u522b\u8be5\u6587\u4ef6");
        }
        if (ExcelUtil.isMergedRegion(sheet, headRow.getRowNum(), 0)) {
            params.setHeadRows(2);
        } else {
            params.setHeadRows(1);
        }
        cellTitle = headRow.cellIterator();
        while (cellTitle.hasNext()) {
            Cell cell = (Cell)cellTitle.next();
            String value = this.getKeyValue(cell);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            titlemap.put(cell.getColumnIndex(), value);
        }
        for (int j = headBegin; j < headBegin + params.getHeadRows() - 1; ++j) {
            headRow = sheet.getRow(j);
            cellTitle = headRow.cellIterator();
            while (cellTitle.hasNext()) {
                Cell cell = (Cell)cellTitle.next();
                String value = this.getKeyValue(cell);
                if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                int columnIndex = cell.getColumnIndex();
                if (ExcelUtil.isMergedRegion(sheet, cell.getRowIndex() - 1, columnIndex)) {
                    collectionName = ExcelUtil.getMergedRegionValue(sheet, cell.getRowIndex() - 1, columnIndex);
                    if (params.isIgnoreHeader(collectionName)) {
                        titlemap.put(cell.getColumnIndex(), value);
                        continue;
                    }
                    titlemap.put(cell.getColumnIndex(), collectionName + "_" + value);
                    continue;
                }
                titlemap.put(cell.getColumnIndex(), value);
            }
        }
        return titlemap;
    }

    private ExcelCollectionParams getCollectionParams(List<ExcelCollectionParams> excelCollection, String collectionName) {
        for (ExcelCollectionParams excelCollectionParams : excelCollection) {
            if (!collectionName.equals(excelCollectionParams.getExcelName())) continue;
            return excelCollectionParams;
        }
        return null;
    }

    public ExcelImportResult importExcelByIs(InputStream inputstream, Class<?> pojoClass, ImportParams params) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel import start ,class is {}", pojoClass);
        }
        ArrayList result = new ArrayList();
        Workbook book = null;
        boolean isXSSFWorkbook = false;
        if (!inputstream.markSupported()) {
            inputstream = new PushbackInputStream(inputstream, 8);
        }
        if ((book = WorkbookFactory.create((InputStream)inputstream)) instanceof XSSFWorkbook) {
            isXSSFWorkbook = true;
        }
        LOGGER.info("  >>>  poi3\u5347\u7ea7\u52304.0\u517c\u5bb9\u6539\u9020\u5de5\u4f5c, isXSSFWorkbook = " + isXSSFWorkbook);
        int sheetNum = book.getNumberOfSheets();
        if (sheetNum > 1) {
            params.setSheetNum(sheetNum);
        }
        this.createErrorCellStyle(book);
        for (int i = 0; i < params.getSheetNum(); ++i) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" start to read excel by is ,startTime is {}", (Object)System.currentTimeMillis());
            }
            Map<String, PictureData> pictures = isXSSFWorkbook ? PoiPublicUtil.getSheetPictrues07((XSSFSheet)book.getSheetAt(i), (XSSFWorkbook)book) : PoiPublicUtil.getSheetPictrues03((HSSFSheet)book.getSheetAt(i), (HSSFWorkbook)book);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" end to read excel by is ,endTime is {}", (Object)new Date().getTime());
            }
            result.addAll(this.importExcel(result, book.getSheetAt(i), pojoClass, params, pictures));
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(" end to read excel list by pos ,endTime is {}", (Object)new Date().getTime());
        }
        if (params.isNeedSave()) {
            this.saveThisExcel(params, pojoClass, isXSSFWorkbook, book);
        }
        return new ExcelImportResult(result, this.verfiyFail, book);
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[100000];
        while ((len = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, len);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private void saveFieldValue(ImportParams params, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString, Row row) throws Exception {
        Object value = this.cellValueServer.getValue(params.getDataHanlder(), object, cell, excelParams, titleString);
        if (object instanceof Map) {
            if (params.getDataHanlder() != null) {
                params.getDataHanlder().setMapValue((Map)object, titleString, value);
            } else {
                ((Map)object).put(titleString, value);
            }
        } else {
            ExcelVerifyHanlderResult verifyResult = this.verifyHandlerServer.verifyData(object, value, titleString, excelParams.get(titleString).getVerify(), params.getVerifyHanlder());
            if (verifyResult.isSuccess()) {
                this.setValues(excelParams.get(titleString), object, value);
            } else {
                Cell errorCell = row.createCell((int)row.getLastCellNum());
                errorCell.setCellValue(verifyResult.getMsg());
                errorCell.setCellStyle(this.errorCellStyle);
                this.verfiyFail = true;
                throw new ExcelImportException(ExcelImportEnum.VERIFY_ERROR);
            }
        }
    }

    private void saveImage(Object object, String picId, Map<String, ExcelImportEntity> excelParams, String titleString, Map<String, PictureData> pictures, ImportParams params) throws Exception {
        if (pictures == null || pictures.get(picId) == null) {
            return;
        }
        PictureData image = pictures.get(picId);
        byte[] data = image.getData();
        String fileName = "pic" + Math.round(Math.random() * 1.0E11);
        fileName = fileName + "." + PoiPublicUtil.getFileExtendName(data);
        int saveType = excelParams.get(titleString).getSaveType();
        if (saveType == 1) {
            String path = PoiPublicUtil.getWebRootPath(this.getSaveUrl(excelParams.get(titleString), object));
            File savefile = new File(path);
            if (!savefile.exists()) {
                savefile.mkdirs();
            }
            savefile = new File(path + "/" + fileName);
            FileOutputStream fos = new FileOutputStream(savefile);
            fos.write(data);
            fos.close();
            this.setValues(excelParams.get(titleString), object, this.getSaveUrl(excelParams.get(titleString), object) + "/" + fileName);
        } else if (saveType == 2) {
            this.setValues(excelParams.get(titleString), object, data);
        } else {
            ImportFileServiceI importFileService = null;
            try {
                importFileService = (ImportFileServiceI)ApplicationContextUtil.getContext().getBean(ImportFileServiceI.class);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
            if (importFileService != null) {
                String dbPath = importFileService.doUpload(data);
                this.setValues(excelParams.get(titleString), object, dbPath);
            }
        }
    }

    private void createErrorCellStyle(Workbook workbook) {
        this.errorCellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setColor((short)10);
        this.errorCellStyle.setFont(font);
    }
}

