/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.support.CompositeRule;

public class ConditionalRuleGroup
extends CompositeRule {
    private Set<Rule> successfulEvaluations;
    private Rule conditionalRule;

    public ConditionalRuleGroup() {
    }

    public ConditionalRuleGroup(String name) {
        super(name);
    }

    public ConditionalRuleGroup(String name, String description) {
        super(name, description);
    }

    public ConditionalRuleGroup(String name, String description, int priority) {
        super(name, description, priority);
    }

    @Override
    public boolean evaluate(Facts facts) {
        this.successfulEvaluations = new HashSet<Rule>();
        this.conditionalRule = this.getRuleWithHighestPriority();
        if (this.conditionalRule.evaluate(facts)) {
            for (Rule rule : this.rules) {
                if (rule == this.conditionalRule || !rule.evaluate(facts)) continue;
                this.successfulEvaluations.add(rule);
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute(Facts facts) throws Exception {
        this.conditionalRule.execute(facts);
        for (Rule rule : this.successfulEvaluations) {
            rule.execute(facts);
        }
    }

    private Rule getRuleWithHighestPriority() {
        List<Rule> copy = this.sortRules();
        Rule highest = copy.get(0);
        if (copy.size() > 1 && copy.get(1).getPriority() == highest.getPriority()) {
            throw new IllegalArgumentException("Only one rule can have highest priority");
        }
        return highest;
    }

    private List<Rule> sortRules() {
        ArrayList<Rule> copy = new ArrayList<Rule>(this.rules);
        Collections.sort(copy, new Comparator<Rule>(){

            @Override
            public int compare(Rule o1, Rule o2) {
                Integer i2 = o2.getPriority();
                return i2.compareTo(o1.getPriority());
            }
        });
        return copy;
    }
}

