/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.spel;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.spel.SpELRule;
import org.jeasy.rules.support.ActivationRuleGroup;
import org.jeasy.rules.support.ConditionalRuleGroup;
import org.jeasy.rules.support.RuleDefinition;
import org.jeasy.rules.support.RuleDefinitionReader;
import org.jeasy.rules.support.UnitRuleGroup;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;

public class SpELRuleFactory {
    private RuleDefinitionReader reader;
    private static final List<String> ALLOWED_COMPOSITE_RULE_TYPES = Arrays.asList(UnitRuleGroup.class.getSimpleName(), ConditionalRuleGroup.class.getSimpleName(), ActivationRuleGroup.class.getSimpleName());

    public SpELRuleFactory(RuleDefinitionReader reader) {
        this.reader = reader;
    }

    public Rule createRule(Reader ruleDescriptor) throws Exception {
        return this.createRule(ruleDescriptor, (ParserContext)new TemplateParserContext());
    }

    public Rule createRule(Reader ruleDescriptor, ParserContext parserContext) throws Exception {
        List ruleDefinitions = this.reader.read(ruleDescriptor);
        if (ruleDefinitions.isEmpty()) {
            throw new IllegalArgumentException("rule descriptor is empty");
        }
        return SpELRuleFactory.createRule((RuleDefinition)ruleDefinitions.get(0), parserContext);
    }

    public Rules createRules(Reader rulesDescriptor) throws Exception {
        return this.createRules(rulesDescriptor, (ParserContext)new TemplateParserContext());
    }

    public Rules createRules(Reader rulesDescriptor, ParserContext parserContext) throws Exception {
        Rules rules = new Rules(new Rule[0]);
        List ruleDefinition = this.reader.read(rulesDescriptor);
        for (RuleDefinition spelRuleDefinition : ruleDefinition) {
            rules.register((Object)SpELRuleFactory.createRule(spelRuleDefinition, parserContext));
        }
        return rules;
    }

    private static Rule createRule(RuleDefinition ruleDefinition, ParserContext context) {
        if (ruleDefinition.isCompositeRule()) {
            return SpELRuleFactory.createCompositeRule(ruleDefinition, context);
        }
        return SpELRuleFactory.createSimpleRule(ruleDefinition, context);
    }

    private static Rule createSimpleRule(RuleDefinition ruleDefinition, ParserContext parserContext) {
        SpELRule spELRule = new SpELRule().name(ruleDefinition.getName()).description(ruleDefinition.getDescription()).priority(ruleDefinition.getPriority()).when(ruleDefinition.getCondition(), parserContext);
        for (String action : ruleDefinition.getActions()) {
            spELRule.then(action, parserContext);
        }
        return spELRule;
    }

    private static Rule createCompositeRule(RuleDefinition ruleDefinition, ParserContext parserContext) {
        UnitRuleGroup compositeRule;
        String name = ruleDefinition.getName();
        switch (ruleDefinition.getCompositeRuleType()) {
            case "UnitRuleGroup": {
                compositeRule = new UnitRuleGroup(name);
                break;
            }
            case "ActivationRuleGroup": {
                compositeRule = new ActivationRuleGroup(name);
                break;
            }
            case "ConditionalRuleGroup": {
                compositeRule = new ConditionalRuleGroup(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid composite rule type, must be one of " + ALLOWED_COMPOSITE_RULE_TYPES);
            }
        }
        compositeRule.setDescription(ruleDefinition.getDescription());
        compositeRule.setPriority(ruleDefinition.getPriority());
        for (RuleDefinition composingRuleDefinition : ruleDefinition.getComposingRules()) {
            compositeRule.addRule((Object)SpELRuleFactory.createRule(composingRuleDefinition, parserContext));
        }
        return compositeRule;
    }
}

