/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.spel;

import org.jeasy.rules.api.Action;
import org.jeasy.rules.api.Facts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpELAction
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpELAction.class);
    private final ExpressionParser parser = new SpelExpressionParser();
    private String expression;
    private Expression compiledExpression;

    public SpELAction(String expression) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression);
    }

    public SpELAction(String expression, ParserContext parserContext) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression, parserContext);
    }

    public void execute(Facts facts) {
        try {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)facts.asMap());
            context.setVariables(facts.asMap());
            this.compiledExpression.getValue((EvaluationContext)context);
        }
        catch (Exception e) {
            LOGGER.error("Unable to evaluate expression: '" + this.expression + "' on facts: " + facts, (Throwable)e);
            throw e;
        }
    }
}

