/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.mvel;

import java.io.Serializable;
import java.util.Map;
import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MVELCondition
implements Condition {
    private static Logger LOGGER = LoggerFactory.getLogger(MVELCondition.class);
    private String expression;
    private Serializable compiledExpression;

    public MVELCondition(String expression) {
        this.expression = expression;
        this.compiledExpression = MVEL.compileExpression((String)expression);
    }

    public boolean evaluate(Facts facts) {
        try {
            return (Boolean)MVEL.executeExpression((Object)this.compiledExpression, (Map)facts.asMap());
        }
        catch (Exception e) {
            LOGGER.debug("Unable to evaluate expression: '" + this.expression + "' on facts: " + facts, (Throwable)e);
            return false;
        }
    }
}

