/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jeasy.rules.annotation.Action;
import org.jeasy.rules.annotation.Condition;
import org.jeasy.rules.annotation.Fact;
import org.jeasy.rules.annotation.Priority;
import org.jeasy.rules.annotation.Rule;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.core.ActionMethodOrderBean;
import org.jeasy.rules.core.NoSuchFactException;
import org.jeasy.rules.core.RuleDefinitionValidator;
import org.jeasy.rules.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleProxy
implements InvocationHandler {
    private final Object target;
    private String name;
    private String description;
    private Integer priority;
    private Method[] methods;
    private Method conditionMethod;
    private Set<ActionMethodOrderBean> actionMethods;
    private Method compareToMethod;
    private Method toStringMethod;
    private Rule annotation;
    private static final RuleDefinitionValidator ruleDefinitionValidator = new RuleDefinitionValidator();
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleProxy.class);

    public static org.jeasy.rules.api.Rule asRule(Object rule) {
        org.jeasy.rules.api.Rule result;
        if (rule instanceof org.jeasy.rules.api.Rule) {
            result = (org.jeasy.rules.api.Rule)rule;
        } else {
            ruleDefinitionValidator.validateRuleDefinition(rule);
            result = (org.jeasy.rules.api.Rule)Proxy.newProxyInstance(org.jeasy.rules.api.Rule.class.getClassLoader(), new Class[]{org.jeasy.rules.api.Rule.class, Comparable.class}, (InvocationHandler)new RuleProxy(rule));
        }
        return result;
    }

    private RuleProxy(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getName": {
                return this.getRuleName();
            }
            case "getDescription": {
                return this.getRuleDescription();
            }
            case "getPriority": {
                return this.getRulePriority();
            }
            case "compareTo": {
                return this.compareToMethod(args);
            }
            case "evaluate": {
                return this.evaluateMethod(args);
            }
            case "execute": {
                return this.executeMethod(args);
            }
            case "equals": {
                return this.equalsMethod(args);
            }
            case "hashCode": {
                return this.hashCodeMethod();
            }
            case "toString": {
                return this.toStringMethod();
            }
        }
        return null;
    }

    private Object evaluateMethod(Object[] args) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)args[0];
        Method conditionMethod = this.getConditionMethod();
        try {
            List<Object> actualParameters = this.getActualParameters(conditionMethod, facts);
            return conditionMethod.invoke(this.target, actualParameters.toArray());
        }
        catch (NoSuchFactException e) {
            LOGGER.warn("Rule '{}' has been evaluated to false due to a declared but missing fact '{}' in {}", new Object[]{this.getTargetClass().getName(), e.getMissingFact(), facts});
            return false;
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Types of injected facts in method '{}' in rule '{}' do not match parameters types", new Object[]{conditionMethod.getName(), this.getTargetClass().getName(), e});
            return false;
        }
    }

    private Object executeMethod(Object[] args) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)args[0];
        for (ActionMethodOrderBean actionMethodBean : this.getActionMethodBeans()) {
            Method actionMethod = actionMethodBean.getMethod();
            List<Object> actualParameters = this.getActualParameters(actionMethod, facts);
            actionMethod.invoke(this.target, actualParameters.toArray());
        }
        return null;
    }

    private Object compareToMethod(Object[] args) throws Exception {
        Method compareToMethod = this.getCompareToMethod();
        if (compareToMethod != null) {
            return compareToMethod.invoke(this.target, args);
        }
        org.jeasy.rules.api.Rule otherRule = (org.jeasy.rules.api.Rule)args[0];
        return this.compareTo(otherRule);
    }

    private List<Object> getActualParameters(Method method, Facts facts) {
        Annotation[][] parameterAnnotations;
        ArrayList<Object> actualParameters = new ArrayList<Object>();
        for (Annotation[] annotations : parameterAnnotations = method.getParameterAnnotations()) {
            if (annotations.length == 1) {
                String factName = ((Fact)annotations[0]).value();
                Object fact = facts.get(factName);
                if (fact == null && !facts.asMap().containsKey(factName)) {
                    throw new NoSuchFactException(String.format("No fact named '%s' found in known facts: %n%s", factName, facts), factName);
                }
                actualParameters.add(fact);
                continue;
            }
            actualParameters.add(facts);
        }
        return actualParameters;
    }

    private boolean equalsMethod(Object[] args) throws Exception {
        if (!(args[0] instanceof org.jeasy.rules.api.Rule)) {
            return false;
        }
        org.jeasy.rules.api.Rule otherRule = (org.jeasy.rules.api.Rule)args[0];
        int otherPriority = otherRule.getPriority();
        int priority = this.getRulePriority();
        if (priority != otherPriority) {
            return false;
        }
        String otherName = otherRule.getName();
        String name = this.getRuleName();
        if (!name.equals(otherName)) {
            return false;
        }
        String otherDescription = otherRule.getDescription();
        String description = this.getRuleDescription();
        return Objects.equals(description, otherDescription);
    }

    private int hashCodeMethod() throws Exception {
        int result = this.getRuleName().hashCode();
        int priority = this.getRulePriority();
        String description = this.getRuleDescription();
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + priority;
        return result;
    }

    private Method getToStringMethod() {
        if (this.toStringMethod == null) {
            Method[] methods;
            for (Method method : methods = this.getMethods()) {
                if (!"toString".equals(method.getName())) continue;
                this.toStringMethod = method;
                return this.toStringMethod;
            }
        }
        return this.toStringMethod;
    }

    private String toStringMethod() throws Exception {
        Method toStringMethod = this.getToStringMethod();
        if (toStringMethod != null) {
            return (String)toStringMethod.invoke(this.target, new Object[0]);
        }
        return this.getRuleName();
    }

    private int compareTo(org.jeasy.rules.api.Rule otherRule) throws Exception {
        int otherPriority = otherRule.getPriority();
        int priority = this.getRulePriority();
        if (priority < otherPriority) {
            return -1;
        }
        if (priority > otherPriority) {
            return 1;
        }
        String otherName = otherRule.getName();
        String name = this.getRuleName();
        return name.compareTo(otherName);
    }

    private int getRulePriority() throws Exception {
        if (this.priority == null) {
            Method[] methods;
            int priority = 0x7FFFFFFE;
            Rule rule = this.getRuleAnnotation();
            if (rule.priority() != 0x7FFFFFFE) {
                priority = rule.priority();
            }
            for (Method method : methods = this.getMethods()) {
                if (!method.isAnnotationPresent(Priority.class)) continue;
                priority = (Integer)method.invoke(this.target, new Object[0]);
                break;
            }
            this.priority = priority;
        }
        return this.priority;
    }

    private Method getConditionMethod() {
        if (this.conditionMethod == null) {
            Method[] methods;
            for (Method method : methods = this.getMethods()) {
                if (!method.isAnnotationPresent(Condition.class)) continue;
                this.conditionMethod = method;
                return this.conditionMethod;
            }
        }
        return this.conditionMethod;
    }

    private Set<ActionMethodOrderBean> getActionMethodBeans() {
        if (this.actionMethods == null) {
            Method[] methods;
            this.actionMethods = new TreeSet<ActionMethodOrderBean>();
            for (Method method : methods = this.getMethods()) {
                if (!method.isAnnotationPresent(Action.class)) continue;
                Action actionAnnotation = method.getAnnotation(Action.class);
                int order = actionAnnotation.order();
                this.actionMethods.add(new ActionMethodOrderBean(method, order));
            }
        }
        return this.actionMethods;
    }

    private Method getCompareToMethod() {
        if (this.compareToMethod == null) {
            Method[] methods;
            for (Method method : methods = this.getMethods()) {
                if (!method.getName().equals("compareTo")) continue;
                this.compareToMethod = method;
                return this.compareToMethod;
            }
        }
        return this.compareToMethod;
    }

    private Method[] getMethods() {
        if (this.methods == null) {
            this.methods = this.getTargetClass().getMethods();
        }
        return this.methods;
    }

    private Rule getRuleAnnotation() {
        if (this.annotation == null) {
            this.annotation = Utils.findAnnotation(Rule.class, this.getTargetClass());
        }
        return this.annotation;
    }

    private String getRuleName() {
        if (this.name == null) {
            Rule rule = this.getRuleAnnotation();
            this.name = rule.name().equals("rule") ? this.getTargetClass().getSimpleName() : rule.name();
        }
        return this.name;
    }

    private String getRuleDescription() {
        if (this.description == null) {
            StringBuilder description = new StringBuilder();
            this.appendConditionMethodName(description);
            this.appendActionMethodsNames(description);
            Rule rule = this.getRuleAnnotation();
            this.description = rule.description().equals("description") ? description.toString() : rule.description();
        }
        return this.description;
    }

    private void appendConditionMethodName(StringBuilder description) {
        Method method = this.getConditionMethod();
        if (method != null) {
            description.append("when ");
            description.append(method.getName());
            description.append(" then ");
        }
    }

    private void appendActionMethodsNames(StringBuilder description) {
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            description.append(iterator.next().getMethod().getName());
            if (!iterator.hasNext()) continue;
            description.append(",");
        }
    }

    private Class<?> getTargetClass() {
        return this.target.getClass();
    }
}

