/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.RulesEngine;
import org.jeasy.rules.api.RulesEngineListener;
import org.jeasy.rules.core.DefaultRuleListener;
import org.jeasy.rules.core.DefaultRulesEngineListener;
import org.jeasy.rules.core.RulesEngineParameters;

abstract class AbstractRuleEngine
implements RulesEngine {
    RulesEngineParameters parameters;
    List<RuleListener> ruleListeners;
    List<RulesEngineListener> rulesEngineListeners;

    AbstractRuleEngine() {
        this(new RulesEngineParameters());
    }

    AbstractRuleEngine(RulesEngineParameters parameters) {
        this.parameters = parameters;
        this.ruleListeners = new ArrayList<RuleListener>();
        this.ruleListeners.add(new DefaultRuleListener());
        this.rulesEngineListeners = new ArrayList<RulesEngineListener>();
        this.rulesEngineListeners.add(new DefaultRulesEngineListener(parameters));
    }

    @Override
    public RulesEngineParameters getParameters() {
        return new RulesEngineParameters(this.parameters.isSkipOnFirstAppliedRule(), this.parameters.isSkipOnFirstFailedRule(), this.parameters.isSkipOnFirstNonTriggeredRule(), this.parameters.getPriorityThreshold());
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return Collections.unmodifiableList(this.ruleListeners);
    }

    @Override
    public List<RulesEngineListener> getRulesEngineListeners() {
        return Collections.unmodifiableList(this.rulesEngineListeners);
    }

    public void registerRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
    }

    public void registerRuleListeners(List<RuleListener> ruleListeners) {
        this.ruleListeners.addAll(ruleListeners);
    }

    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        this.rulesEngineListeners.add(rulesEngineListener);
    }

    public void registerRulesEngineListeners(List<RulesEngineListener> rulesEngineListeners) {
        this.rulesEngineListeners.addAll(rulesEngineListeners);
    }
}

