/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jeasy.rules.annotation.Action;
import org.jeasy.rules.annotation.Condition;
import org.jeasy.rules.annotation.Fact;
import org.jeasy.rules.annotation.Priority;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.core.ActionMethodOrderBean;
import org.jeasy.rules.core.NoSuchFactException;
import org.jeasy.rules.core.RuleDefinitionValidator;
import org.jeasy.rules.core.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleProxy
implements InvocationHandler {
    private Object target;
    private static RuleDefinitionValidator ruleDefinitionValidator = new RuleDefinitionValidator();
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleProxy.class);

    private RuleProxy(Object target) {
        this.target = target;
    }

    public static Rule asRule(Object rule) {
        Rule result;
        if (rule instanceof Rule) {
            result = (Rule)rule;
        } else {
            ruleDefinitionValidator.validateRuleDefinition(rule);
            result = (Rule)Proxy.newProxyInstance(Rule.class.getClassLoader(), new Class[]{Rule.class, Comparable.class}, (InvocationHandler)new RuleProxy(rule));
        }
        return result;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getName": {
                return this.getRuleName();
            }
            case "getDescription": {
                return this.getRuleDescription();
            }
            case "getPriority": {
                return this.getRulePriority();
            }
            case "compareTo": {
                return this.compareToMethod(args);
            }
            case "evaluate": {
                return this.evaluateMethod(args);
            }
            case "execute": {
                return this.executeMethod(args);
            }
            case "equals": {
                return this.equalsMethod(args);
            }
            case "hashCode": {
                return this.hashCodeMethod();
            }
            case "toString": {
                return this.toStringMethod();
            }
        }
        return null;
    }

    private Object evaluateMethod(Object[] args) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)args[0];
        Method conditionMethod = this.getConditionMethod();
        try {
            List<Object> actualParameters = this.getActualParameters(conditionMethod, facts);
            return conditionMethod.invoke(this.target, actualParameters.toArray());
        }
        catch (NoSuchFactException e) {
            LOGGER.info("Rule '{}' has been evaluated to false due to a declared but missing fact '{}' in {}", new Object[]{this.getTargetClass().getName(), e.getMissingFact(), facts});
            return false;
        }
        catch (IllegalArgumentException e) {
            String error = "Types of injected facts in method '%s' in rule '%s' do not match parameters types";
            throw new RuntimeException(String.format(error, conditionMethod.getName(), this.getTargetClass().getName()), e);
        }
    }

    private Object executeMethod(Object[] args) throws IllegalAccessException, InvocationTargetException {
        Facts facts = (Facts)args[0];
        for (ActionMethodOrderBean actionMethodBean : this.getActionMethodBeans()) {
            Method actionMethod = actionMethodBean.getMethod();
            List<Object> actualParameters = this.getActualParameters(actionMethod, facts);
            actionMethod.invoke(this.target, actualParameters.toArray());
        }
        return null;
    }

    private Object compareToMethod(Object[] args) throws Exception {
        Method compareToMethod = this.getCompareToMethod();
        if (compareToMethod != null) {
            return compareToMethod.invoke(this.target, args);
        }
        Rule otherRule = (Rule)args[0];
        return this.compareTo(otherRule);
    }

    private List<Object> getActualParameters(Method method, Facts facts) {
        Annotation[][] parameterAnnotations;
        ArrayList<Object> actualParameters = new ArrayList<Object>();
        for (Annotation[] annotations : parameterAnnotations = method.getParameterAnnotations()) {
            if (annotations.length == 1) {
                String factName = ((Fact)annotations[0]).value();
                Object fact = facts.get(factName);
                if (fact == null && !facts.asMap().containsKey(factName)) {
                    throw new NoSuchFactException(String.format("No fact named '%s' found in known facts: \n%s", factName, facts), factName);
                }
                actualParameters.add(fact);
                continue;
            }
            actualParameters.add(facts);
        }
        return actualParameters;
    }

    private boolean equalsMethod(Object[] args) throws Exception {
        if (!(args[0] instanceof Rule)) {
            return false;
        }
        Rule otherRule = (Rule)args[0];
        int otherPriority = otherRule.getPriority();
        int priority = this.getRulePriority();
        if (priority != otherPriority) {
            return false;
        }
        String otherName = otherRule.getName();
        String name = this.getRuleName();
        if (!name.equals(otherName)) {
            return false;
        }
        String otherDescription = otherRule.getDescription();
        String description = this.getRuleDescription();
        return !(description == null ? otherDescription != null : !description.equals(otherDescription));
    }

    private int hashCodeMethod() throws Exception {
        int result = this.getRuleName().hashCode();
        int priority = this.getRulePriority();
        String description = this.getRuleDescription();
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + priority;
        return result;
    }

    private String toStringMethod() throws Exception {
        Method[] methods;
        for (Method method : methods = this.getMethods()) {
            if (!"toString".equals(method.getName())) continue;
            return (String)method.invoke(this.target, new Object[0]);
        }
        return this.getRuleName();
    }

    private int compareTo(Rule otherRule) throws Exception {
        int otherPriority = otherRule.getPriority();
        int priority = this.getRulePriority();
        if (priority < otherPriority) {
            return -1;
        }
        if (priority > otherPriority) {
            return 1;
        }
        String otherName = otherRule.getName();
        String name = this.getRuleName();
        return name.compareTo(otherName);
    }

    private int getRulePriority() throws Exception {
        Method[] methods;
        int priority = 0x7FFFFFFE;
        org.jeasy.rules.annotation.Rule rule = this.getRuleAnnotation();
        if (rule.priority() != 0x7FFFFFFE) {
            priority = rule.priority();
        }
        for (Method method : methods = this.getMethods()) {
            if (!method.isAnnotationPresent(Priority.class)) continue;
            priority = (Integer)method.invoke(this.target, new Object[0]);
            break;
        }
        return priority;
    }

    private Method getConditionMethod() {
        Method[] methods;
        for (Method method : methods = this.getMethods()) {
            if (!method.isAnnotationPresent(Condition.class)) continue;
            return method;
        }
        return null;
    }

    private Set<ActionMethodOrderBean> getActionMethodBeans() {
        Method[] methods = this.getMethods();
        TreeSet<ActionMethodOrderBean> actionMethodBeans = new TreeSet<ActionMethodOrderBean>();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(Action.class)) continue;
            Action actionAnnotation = method.getAnnotation(Action.class);
            int order = actionAnnotation.order();
            actionMethodBeans.add(new ActionMethodOrderBean(method, order));
        }
        return actionMethodBeans;
    }

    private Method getCompareToMethod() {
        Method[] methods;
        for (Method method : methods = this.getMethods()) {
            if (!method.getName().equals("compareTo")) continue;
            return method;
        }
        return null;
    }

    private Method[] getMethods() {
        return this.getTargetClass().getMethods();
    }

    private org.jeasy.rules.annotation.Rule getRuleAnnotation() {
        return Utils.findAnnotation(org.jeasy.rules.annotation.Rule.class, this.getTargetClass());
    }

    private String getRuleName() {
        org.jeasy.rules.annotation.Rule rule = this.getRuleAnnotation();
        return rule.name().equals("rule") ? this.getTargetClass().getSimpleName() : rule.name();
    }

    private String getRuleDescription() {
        StringBuilder description = new StringBuilder();
        this.appendConditionMethodName(description);
        this.appendActionMethodsNames(description);
        org.jeasy.rules.annotation.Rule rule = this.getRuleAnnotation();
        return rule.description().equals("description") ? description.toString() : rule.description();
    }

    private void appendConditionMethodName(StringBuilder description) {
        Method method = this.getConditionMethod();
        if (method != null) {
            description.append("when ");
            description.append(method.getName());
            description.append(" then ");
        }
    }

    private void appendActionMethodsNames(StringBuilder description) {
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            description.append(iterator.next().getMethod().getName());
            if (!iterator.hasNext()) continue;
            description.append(",");
        }
    }

    private Class<?> getTargetClass() {
        return this.target.getClass();
    }
}

