/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngine;
import org.jeasy.rules.api.RulesEngineListener;
import org.jeasy.rules.core.DefaultRulesEngine;
import org.jeasy.rules.core.RulesEngineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InferenceRulesEngine
implements RulesEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(InferenceRulesEngine.class);
    private RulesEngineParameters parameters;
    private List<RuleListener> ruleListeners;
    private List<RulesEngineListener> rulesEngineListeners;
    private DefaultRulesEngine delegate;

    public InferenceRulesEngine() {
        this(new RulesEngineParameters());
    }

    public InferenceRulesEngine(RulesEngineParameters parameters) {
        this.parameters = parameters;
        this.delegate = new DefaultRulesEngine(parameters);
        this.ruleListeners = new ArrayList<RuleListener>();
        this.rulesEngineListeners = new ArrayList<RulesEngineListener>();
    }

    @Override
    public RulesEngineParameters getParameters() {
        return this.parameters;
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return this.ruleListeners;
    }

    @Override
    public List<RulesEngineListener> getRulesEngineListeners() {
        return this.rulesEngineListeners;
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        Set<Rule> selectedRules;
        do {
            LOGGER.info("Selecting candidate rules based on the following facts: {}", (Object)facts);
            selectedRules = this.selectCandidates(rules, facts);
            if (!selectedRules.isEmpty()) {
                this.delegate.doFire(new Rules(selectedRules), facts);
                continue;
            }
            LOGGER.info("No candidate rules found for facts: {}", (Object)facts);
        } while (!selectedRules.isEmpty());
    }

    private Set<Rule> selectCandidates(Rules rules, Facts facts) {
        TreeSet<Rule> candidates = new TreeSet<Rule>();
        for (Rule rule : rules) {
            if (!rule.evaluate(facts)) continue;
            candidates.add(rule);
        }
        return candidates;
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        return this.delegate.check(rules, facts);
    }

    public void registerRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
        this.delegate.registerRuleListener(ruleListener);
    }

    public void registerRuleListeners(List<RuleListener> ruleListeners) {
        this.ruleListeners.addAll(ruleListeners);
        this.delegate.registerRuleListeners(ruleListeners);
    }

    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        this.rulesEngineListeners.add(rulesEngineListener);
        this.delegate.registerRulesEngineListener(rulesEngineListener);
    }

    public void registerRulesEngineListeners(List<RulesEngineListener> rulesEngineListeners) {
        this.rulesEngineListeners.addAll(rulesEngineListeners);
        this.delegate.registerRulesEngineListeners(rulesEngineListeners);
    }
}

