/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRuleListener
implements RuleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRuleListener.class);

    DefaultRuleListener() {
    }

    @Override
    public boolean beforeEvaluate(Rule rule, Facts facts) {
        return true;
    }

    @Override
    public void afterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        String ruleName = rule.getName();
        if (evaluationResult) {
            LOGGER.info("Rule '{}' triggered", (Object)ruleName);
        } else {
            LOGGER.info("Rule '{}' has been evaluated to false, it has not been executed", (Object)ruleName);
        }
    }

    @Override
    public void beforeExecute(Rule rule, Facts facts) {
    }

    @Override
    public void onSuccess(Rule rule, Facts facts) {
        LOGGER.info("Rule '{}' performed successfully", (Object)rule.getName());
    }

    @Override
    public void onFailure(Rule rule, Facts facts, Exception exception) {
        LOGGER.info("Rule '" + rule.getName() + "' performed with error", (Throwable)exception);
    }
}

