/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.Map;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngineListener;
import org.jeasy.rules.core.DefaultRuleListener;
import org.jeasy.rules.core.RulesEngineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultRulesEngineListener
implements RulesEngineListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRuleListener.class);
    private RulesEngineParameters parameters;

    DefaultRulesEngineListener(RulesEngineParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public void beforeEvaluate(Rules rules, Facts facts) {
        if (!rules.isEmpty()) {
            this.logEngineParameters();
            this.log(rules);
            this.log(facts);
            LOGGER.info("Rules evaluation started");
        } else {
            LOGGER.warn("No rules registered! Nothing to apply");
        }
    }

    @Override
    public void afterExecute(Rules rules, Facts facts) {
    }

    private void logEngineParameters() {
        LOGGER.info(this.parameters.toString());
    }

    private void log(Rules rules) {
        LOGGER.info("Registered rules:");
        for (Rule rule : rules) {
            LOGGER.info("Rule { name = '{}', description = '{}', priority = '{}'}", new Object[]{rule.getName(), rule.getDescription(), rule.getPriority()});
        }
    }

    private void log(Facts facts) {
        LOGGER.info("Known facts:");
        for (Map.Entry<String, Object> fact : facts) {
            LOGGER.info("Fact { {} : {} }", (Object)fact.getKey(), (Object)String.valueOf(fact.getValue()));
        }
    }
}

