/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.rules.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.api.RulesEngine;
import org.jeasy.rules.api.RulesEngineListener;
import org.jeasy.rules.core.DefaultRuleListener;
import org.jeasy.rules.core.DefaultRulesEngineListener;
import org.jeasy.rules.core.RulesEngineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRulesEngine
implements RulesEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRuleListener.class);
    private RulesEngineParameters parameters;
    private List<RuleListener> ruleListeners;
    private List<RulesEngineListener> rulesEngineListeners;

    public DefaultRulesEngine() {
        this(new RulesEngineParameters());
    }

    public DefaultRulesEngine(RulesEngineParameters parameters) {
        this.parameters = parameters;
        this.ruleListeners = new ArrayList<RuleListener>();
        this.ruleListeners.add(new DefaultRuleListener());
        this.rulesEngineListeners = new ArrayList<RulesEngineListener>();
        this.rulesEngineListeners.add(new DefaultRulesEngineListener(parameters));
    }

    @Override
    public RulesEngineParameters getParameters() {
        return this.parameters;
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return this.ruleListeners;
    }

    @Override
    public List<RulesEngineListener> getRulesEngineListeners() {
        return this.rulesEngineListeners;
    }

    @Override
    public void fire(Rules rules, Facts facts) {
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    void doFire(Rules rules, Facts facts) {
        for (Rule rule : rules) {
            String name = rule.getName();
            int priority = rule.getPriority();
            if (priority > this.parameters.getPriorityThreshold()) {
                LOGGER.info("Rule priority threshold ({}) exceeded at rule '{}' with priority={}, next rules will be skipped", new Object[]{this.parameters.getPriorityThreshold(), name, priority});
                break;
            }
            if (!this.shouldBeEvaluated(rule, facts)) {
                LOGGER.info("Rule '{}' has been skipped before being evaluated", (Object)name);
                continue;
            }
            if (rule.evaluate(facts)) {
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.info("Next rules will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.info("Next rules will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.info("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    @Override
    public Map<Rule, Boolean> check(Rules rules, Facts facts) {
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> result = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return result;
    }

    private Map<Rule, Boolean> doCheck(Rules rules, Facts facts) {
        LOGGER.info("Checking rules");
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : rules) {
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            result.put(rule, rule.evaluate(facts));
        }
        return result;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onFailure(rule, facts, exception);
        }
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onSuccess(rule, facts);
        }
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.beforeExecute(rule, facts);
        }
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        for (RuleListener ruleListener : this.ruleListeners) {
            if (ruleListener.beforeEvaluate(rule, facts)) continue;
            return false;
        }
        return true;
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean evaluationResult) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.afterEvaluate(rule, facts, evaluationResult);
        }
    }

    private void triggerListenersBeforeRules(Rules rule, Facts facts) {
        for (RulesEngineListener rulesEngineListener : this.rulesEngineListeners) {
            rulesEngineListener.beforeEvaluate(rule, facts);
        }
    }

    private void triggerListenersAfterRules(Rules rule, Facts facts) {
        for (RulesEngineListener rulesEngineListener : this.rulesEngineListeners) {
            rulesEngineListener.afterExecute(rule, facts);
        }
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }

    public void registerRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
    }

    public void registerRuleListeners(List<RuleListener> ruleListeners) {
        this.ruleListeners.addAll(ruleListeners);
    }

    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        this.rulesEngineListeners.add(rulesEngineListener);
    }

    public void registerRulesEngineListeners(List<RulesEngineListener> rulesEngineListeners) {
        this.rulesEngineListeners.addAll(rulesEngineListeners);
    }
}

