/*
 * The MIT License
 *
 *   Copyright (c) 2020, Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 *
 *   Permission is hereby granted, free of charge, to any person obtaining a copy
 *   of this software and associated documentation files (the "Software"), to deal
 *   in the Software without restriction, including without limitation the rights
 *   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *   copies of the Software, and to permit persons to whom the Software is
 *   furnished to do so, subject to the following conditions:
 *
 *   The above copyright notice and this permission notice shall be included in
 *   all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *   THE SOFTWARE.
 */
package org.jeasy.random.randomizers;

import org.jeasy.random.api.Randomizer;

/**
 * A generic {@link Randomizer} that generates random values from a list of words.
 *
 * @author Mahmoud Ben Hassine (mahmoud.benhassine@icloud.com)
 */
public class GenericStringRandomizer extends FakerBasedRandomizer<String> {

    private final String[] words;

    /**
     * Create a new {@link GenericStringRandomizer}.
     *
     * @param words the list of words from which this randomizer will generate random values.
     */
    public GenericStringRandomizer(final String[] words) {
        super();
        this.words = words;
    }

    /**
     * Create a new {@link GenericStringRandomizer}.
     *
     * @param words the list of words from which this randomizer will generate random values.
     * @param seed  the initial seed
     */
    public GenericStringRandomizer(final String[] words, final long seed) {
        super(seed);
        this.words = words;
    }

    /**
     * Create a new {@link GenericStringRandomizer}.
     *
     * @param words the list of words from which this randomizer will generate random values.
     * @return a new {@link GenericStringRandomizer}
     * @deprecated in favor of the equivalent constructor
     */
    @Deprecated
    public static GenericStringRandomizer aNewGenericStringRandomizer(final String[] words) {
        return new GenericStringRandomizer(words);
    }

    /**
     * Create a new {@link GenericStringRandomizer}.
     *
     * @param words the list of words from which this randomizer will generate random values.
     * @param seed  the initial seed
     * @return a new {@link GenericStringRandomizer}
     * @deprecated in favor of the equivalent constructor
     */
    @Deprecated
    public static GenericStringRandomizer aNewGenericStringRandomizer(final String[] words, final long seed) {
        return new GenericStringRandomizer(words, seed);
    }

    @Override
    public String getRandomValue() {
        return faker.options().option(words);
    }

}
