/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;

public class DurationRandomizer
implements Randomizer<Duration> {
    private static final int MIN_AMOUNT = 0;
    private static final int MAX_AMOUNT = 100;
    private final IntegerRangeRandomizer amountRandomizer;
    private final TemporalUnit unit;

    public DurationRandomizer() {
        this(ChronoUnit.HOURS);
    }

    public DurationRandomizer(TemporalUnit unit) {
        this(new IntegerRangeRandomizer(0, 100), unit);
    }

    public DurationRandomizer(long seed) {
        this(seed, (TemporalUnit)ChronoUnit.HOURS);
    }

    public DurationRandomizer(long seed, TemporalUnit unit) {
        this(new IntegerRangeRandomizer(0, 100, seed), unit);
    }

    private DurationRandomizer(IntegerRangeRandomizer amountRandomizer, TemporalUnit unit) {
        this.amountRandomizer = amountRandomizer;
        this.unit = DurationRandomizer.requireValid(unit);
    }

    @Override
    public Duration getRandomValue() {
        int randomAmount = this.amountRandomizer.getRandomValue();
        return Duration.of(randomAmount, this.unit);
    }

    private static TemporalUnit requireValid(TemporalUnit unit) {
        if (unit.isDurationEstimated() && unit != ChronoUnit.DAYS) {
            throw new IllegalArgumentException("Temporal unit " + unit + " can't be used to create Duration objects");
        }
        return unit;
    }
}

