/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.time;

import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.misc.EnumRandomizer;
import org.jeasy.random.randomizers.time.DayRandomizer;
import org.jeasy.random.randomizers.time.YearRandomizer;

public class LocalDateRandomizer
implements Randomizer<LocalDate> {
    private final YearRandomizer yearRandomizer;
    private final EnumRandomizer<Month> monthRandomizer;
    private final DayRandomizer dayRandomizer;

    public LocalDateRandomizer() {
        this.yearRandomizer = new YearRandomizer();
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class);
        this.dayRandomizer = new DayRandomizer();
    }

    public LocalDateRandomizer(long seed) {
        this.yearRandomizer = new YearRandomizer(seed);
        this.monthRandomizer = new EnumRandomizer<Month>(Month.class, seed);
        this.dayRandomizer = new DayRandomizer(seed);
    }

    @Deprecated
    public static LocalDateRandomizer aNewLocalDateRandomizer() {
        return new LocalDateRandomizer();
    }

    @Deprecated
    public static LocalDateRandomizer aNewLocalDateRandomizer(long seed) {
        return new LocalDateRandomizer(seed);
    }

    @Override
    public LocalDate getRandomValue() {
        Year randomYear = this.yearRandomizer.getRandomValue();
        Month randomMonth = (Month)this.monthRandomizer.getRandomValue();
        int randomDay = this.dayRandomizer.getRandomValue();
        return LocalDate.of(randomYear.getValue(), randomMonth.getValue(), randomDay);
    }
}

