/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoField;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class LocalDateRangeRandomizer
extends AbstractRangeRandomizer<LocalDate> {
    public LocalDateRangeRandomizer(LocalDate min, LocalDate max) {
        super(min, max);
    }

    public LocalDateRangeRandomizer(LocalDate min, LocalDate max, long seed) {
        super(min, max, seed);
    }

    @Deprecated
    public static LocalDateRangeRandomizer aNewLocalDateRangeRandomizer(LocalDate min, LocalDate max) {
        return new LocalDateRangeRandomizer(min, max);
    }

    @Deprecated
    public static LocalDateRangeRandomizer aNewLocalDateRangeRandomizer(LocalDate min, LocalDate max, long seed) {
        return new LocalDateRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((LocalDate)this.min).isAfter((ChronoLocalDate)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected LocalDate getDefaultMinValue() {
        return LocalDate.MIN;
    }

    @Override
    protected LocalDate getDefaultMaxValue() {
        return LocalDate.MAX;
    }

    @Override
    public LocalDate getRandomValue() {
        long minEpochDay = ((LocalDate)this.min).getLong(ChronoField.EPOCH_DAY);
        long maxEpochDay = ((LocalDate)this.max).getLong(ChronoField.EPOCH_DAY);
        long randomEpochDay = (long)this.nextDouble(minEpochDay, maxEpochDay);
        return LocalDate.ofEpochDay(randomEpochDay);
    }
}

