/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TransferQueue;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jeasy.random.ObjectCreationException;
import org.jeasy.random.annotation.RandomizerArgument;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.util.ClassGraphFacade;
import org.jeasy.random.util.DateUtils;
import org.jeasy.random.util.PrimitiveEnum;
import org.objenesis.ObjenesisStd;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> Randomizer<T> asRandomizer(Supplier<T> supplier) {
        class RandomizerProxy
        implements InvocationHandler {
            private final Supplier<?> target;

            RandomizerProxy(Supplier<?> target) {
                this.target = target;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("getRandomValue".equals(method.getName())) {
                    Method getMethod = this.target.getClass().getMethod("get", new Class[0]);
                    getMethod.setAccessible(true);
                    return getMethod.invoke(this.target, new Object[0]);
                }
                return null;
            }
        }
        return (Randomizer)Proxy.newProxyInstance(Randomizer.class.getClassLoader(), new Class[]{Randomizer.class}, (InvocationHandler)new RandomizerProxy(supplier));
    }

    public static <T> List<Field> getDeclaredFields(T type) {
        return new ArrayList<Field>(Arrays.asList(type.getClass().getDeclaredFields()));
    }

    public static List<Field> getInheritedFields(Class<?> type) {
        ArrayList<Field> inheritedFields = new ArrayList<Field>();
        while (type.getSuperclass() != null) {
            Class<?> superclass = type.getSuperclass();
            inheritedFields.addAll(Arrays.asList(superclass.getDeclaredFields()));
            type = superclass;
        }
        return inheritedFields;
    }

    public static void setProperty(Object object, Field field, Object value) throws IllegalAccessException {
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), object.getClass());
            Method setter = propertyDescriptor.getWriteMethod();
            if (setter != null) {
                setter.invoke(object, value);
            } else {
                ReflectionUtils.setFieldValue(object, field, value);
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            ReflectionUtils.setFieldValue(object, field, value);
        }
    }

    public static void setFieldValue(Object object, Field field, Object value) throws IllegalAccessException {
        boolean access = field.isAccessible();
        field.setAccessible(true);
        field.set(object, value);
        field.setAccessible(access);
    }

    public static Object getFieldValue(Object object, Field field) throws IllegalAccessException {
        boolean access = field.isAccessible();
        field.setAccessible(true);
        Object value = field.get(object);
        field.setAccessible(access);
        return value;
    }

    public static Class<?> getWrapperType(Class<?> primitiveType) {
        for (PrimitiveEnum p : PrimitiveEnum.values()) {
            if (!p.getType().equals(primitiveType)) continue;
            return p.getClazz();
        }
        return primitiveType;
    }

    public static boolean isPrimitiveFieldWithDefaultValue(Object object, Field field) throws IllegalAccessException {
        Class<?> fieldType = field.getType();
        if (!fieldType.isPrimitive()) {
            return false;
        }
        Object fieldValue = ReflectionUtils.getFieldValue(object, field);
        if (fieldValue == null) {
            return false;
        }
        if (fieldType.equals(Boolean.TYPE) && !((Boolean)fieldValue).booleanValue()) {
            return true;
        }
        if (fieldType.equals(Byte.TYPE) && (Byte)fieldValue == 0) {
            return true;
        }
        if (fieldType.equals(Short.TYPE) && (Short)fieldValue == 0) {
            return true;
        }
        if (fieldType.equals(Integer.TYPE) && (Integer)fieldValue == 0) {
            return true;
        }
        if (fieldType.equals(Long.TYPE) && (Long)fieldValue == 0L) {
            return true;
        }
        if (fieldType.equals(Float.TYPE) && ((Float)fieldValue).floatValue() == 0.0f) {
            return true;
        }
        if (fieldType.equals(Double.TYPE) && (Double)fieldValue == 0.0) {
            return true;
        }
        return fieldType.equals(Character.TYPE) && ((Character)fieldValue).charValue() == '\u0000';
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isInterface(Class<?> type) {
        return type.isInterface();
    }

    public static <T> boolean isAbstract(Class<T> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static <T> boolean isPublic(Class<T> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isArrayType(Class<?> type) {
        return type.isArray();
    }

    public static boolean isEnumType(Class<?> type) {
        return type.isEnum();
    }

    public static boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type);
    }

    public static boolean isCollectionType(Type type) {
        return ReflectionUtils.isParameterizedType(type) && ReflectionUtils.isCollectionType((Class)((ParameterizedType)type).getRawType());
    }

    public static boolean isPopulatable(Type type) {
        return !ReflectionUtils.isWildcardType(type) && !ReflectionUtils.isTypeVariable(type) && !ReflectionUtils.isCollectionType(type) && !ReflectionUtils.isParameterizedType(type);
    }

    public static boolean isIntrospectable(Class<?> type) {
        return !(ReflectionUtils.isEnumType(type) || ReflectionUtils.isArrayType(type) || ReflectionUtils.isCollectionType(type) && ReflectionUtils.isJdkBuiltIn(type) || ReflectionUtils.isMapType(type) && ReflectionUtils.isJdkBuiltIn(type));
    }

    public static boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }

    public static boolean isJdkBuiltIn(Class<?> type) {
        return type.getName().startsWith("java.util");
    }

    public static boolean isParameterizedType(Type type) {
        return type != null && type instanceof ParameterizedType && ((ParameterizedType)type).getActualTypeArguments().length > 0;
    }

    public static boolean isWildcardType(Type type) {
        return type instanceof WildcardType;
    }

    public static boolean isTypeVariable(Type type) {
        return type instanceof TypeVariable;
    }

    public static <T> List<Class<?>> getPublicConcreteSubTypesOf(Class<T> type) {
        return ClassGraphFacade.getPublicConcreteSubTypesOf(type);
    }

    public static List<Class<?>> filterSameParameterizedTypes(List<Class<?>> types, Type type) {
        if (type instanceof ParameterizedType) {
            Type[] fieldArugmentTypes = ((ParameterizedType)type).getActualTypeArguments();
            ArrayList typesWithSameParameterizedTypes = new ArrayList();
            for (Class<?> currentConcreteType : types) {
                List<Type[]> actualTypeArguments = ReflectionUtils.getActualTypeArgumentsOfGenericInterfaces(currentConcreteType);
                typesWithSameParameterizedTypes.addAll(actualTypeArguments.stream().filter(currentTypeArguments -> Arrays.equals(fieldArugmentTypes, currentTypeArguments)).map(currentTypeArguments -> currentConcreteType).collect(Collectors.toList()));
            }
            return typesWithSameParameterizedTypes;
        }
        return types;
    }

    public static <T extends Annotation> T getAnnotation(Field field, Class<T> annotationType) {
        return field.getAnnotation(annotationType) == null ? ReflectionUtils.getAnnotationFromReadMethod(ReflectionUtils.getReadMethod(field).orElse(null), annotationType) : field.getAnnotation(annotationType);
    }

    public static boolean isAnnotationPresent(Field field, Class<? extends Annotation> annotationType) {
        Optional<Method> readMethod = ReflectionUtils.getReadMethod(field);
        return field.isAnnotationPresent(annotationType) || readMethod.isPresent() && readMethod.get().isAnnotationPresent(annotationType);
    }

    public static Collection<?> getEmptyImplementationForCollectionInterface(Class<?> collectionInterface) {
        AbstractCollection collection = new ArrayList();
        if (List.class.isAssignableFrom(collectionInterface)) {
            collection = new ArrayList();
        } else if (NavigableSet.class.isAssignableFrom(collectionInterface)) {
            collection = new TreeSet();
        } else if (SortedSet.class.isAssignableFrom(collectionInterface)) {
            collection = new TreeSet();
        } else if (Set.class.isAssignableFrom(collectionInterface)) {
            collection = new HashSet();
        } else if (BlockingDeque.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedBlockingDeque();
        } else if (Deque.class.isAssignableFrom(collectionInterface)) {
            collection = new ArrayDeque();
        } else if (TransferQueue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedTransferQueue();
        } else if (BlockingQueue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedBlockingQueue();
        } else if (Queue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedList();
        }
        return collection;
    }

    public static Collection<?> createEmptyCollectionForType(Class<?> fieldType, int initialSize) {
        Collection collection;
        ReflectionUtils.rejectUnsupportedTypes(fieldType);
        try {
            collection = (ArrayBlockingQueue)fieldType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            collection = fieldType.equals(ArrayBlockingQueue.class) ? new ArrayBlockingQueue(initialSize) : (Collection)new ObjenesisStd().newInstance(fieldType);
        }
        return collection;
    }

    public static Map<?, ?> getEmptyImplementationForMapInterface(Class<?> mapInterface) {
        AbstractMap map = new HashMap();
        if (ConcurrentNavigableMap.class.isAssignableFrom(mapInterface)) {
            map = new ConcurrentSkipListMap();
        } else if (ConcurrentMap.class.isAssignableFrom(mapInterface)) {
            map = new ConcurrentHashMap();
        } else if (NavigableMap.class.isAssignableFrom(mapInterface)) {
            map = new TreeMap();
        } else if (SortedMap.class.isAssignableFrom(mapInterface)) {
            map = new TreeMap();
        }
        return map;
    }

    private static void rejectUnsupportedTypes(Class<?> type) {
        if (type.equals(SynchronousQueue.class)) {
            throw new UnsupportedOperationException(SynchronousQueue.class.getName() + " type is not supported");
        }
        if (type.equals(DelayQueue.class)) {
            throw new UnsupportedOperationException(DelayQueue.class.getName() + " type is not supported");
        }
    }

    public static Optional<Method> getReadMethod(Field field) {
        String fieldName = field.getName();
        Class<?> fieldClass = field.getDeclaringClass();
        String capitalizedFieldName = fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
        Optional<Method> getter = ReflectionUtils.getPublicMethod("get" + capitalizedFieldName, fieldClass);
        if (getter.isPresent()) {
            return getter;
        }
        return ReflectionUtils.getPublicMethod("is" + capitalizedFieldName, fieldClass);
    }

    private static Optional<Method> getPublicMethod(String name, Class<?> target) {
        try {
            return Optional.of(target.getMethod(name, new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            return Optional.empty();
        }
    }

    private static <T extends Annotation> T getAnnotationFromReadMethod(Method readMethod, Class<T> clazz) {
        return readMethod == null ? null : (T)readMethod.getAnnotation(clazz);
    }

    private static List<Type[]> getActualTypeArgumentsOfGenericInterfaces(Class<?> type) {
        Type[] genericInterfaceTypes;
        ArrayList<Type[]> actualTypeArguments = new ArrayList<Type[]>();
        for (Type currentGenericInterfaceType : genericInterfaceTypes = type.getGenericInterfaces()) {
            if (!(currentGenericInterfaceType instanceof ParameterizedType)) continue;
            actualTypeArguments.add(((ParameterizedType)currentGenericInterfaceType).getActualTypeArguments());
        }
        return actualTypeArguments;
    }

    public static <T> Randomizer<T> newInstance(Class<T> type, RandomizerArgument[] randomizerArguments) {
        try {
            Optional<Constructor> matchingConstructor;
            if (ReflectionUtils.notEmpty(randomizerArguments) && (matchingConstructor = Stream.of(type.getConstructors()).filter(constructor -> ReflectionUtils.hasSameArgumentNumber(constructor, randomizerArguments) && ReflectionUtils.hasSameArgumentTypes(constructor, randomizerArguments)).findFirst()).isPresent()) {
                return (Randomizer)matchingConstructor.get().newInstance(ReflectionUtils.convertArguments(randomizerArguments));
            }
            return (Randomizer)type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ObjectCreationException(String.format("Could not create Randomizer of type: %s with constructor arguments: %s", type, Arrays.toString(randomizerArguments)), e);
        }
    }

    private static boolean notEmpty(RandomizerArgument[] randomizerArguments) {
        return randomizerArguments != null && randomizerArguments.length > 0;
    }

    private static boolean hasSameArgumentNumber(Constructor<?> constructor, RandomizerArgument[] randomizerArguments) {
        return constructor.getParameterCount() == randomizerArguments.length;
    }

    private static boolean hasSameArgumentTypes(Constructor<?> constructor, RandomizerArgument[] randomizerArguments) {
        Class<?>[] constructorParameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < randomizerArguments.length; ++i) {
            if (constructorParameterTypes[i].isAssignableFrom(randomizerArguments[i].type())) continue;
            return false;
        }
        return true;
    }

    private static Object[] convertArguments(RandomizerArgument[] declaredArguments) {
        int numberOfArguments = declaredArguments.length;
        Object[] arguments = new Object[numberOfArguments];
        for (int i = 0; i < numberOfArguments; ++i) {
            Class<?> type = declaredArguments[i].type();
            String value = declaredArguments[i].value();
            if (type.isArray()) {
                Object[] values = Stream.of(value.split(",")).map(String::trim).toArray();
                arguments[i] = ReflectionUtils.convertArray(values, type);
                continue;
            }
            arguments[i] = ReflectionUtils.convertValue(value, type);
        }
        return arguments;
    }

    private static Object convertValue(String value, Class<?> targetType) {
        if (Boolean.class.equals(targetType) || Boolean.TYPE.equals(targetType)) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class.equals(targetType) || Byte.TYPE.equals(targetType)) {
            return Byte.parseByte(value);
        }
        if (Short.class.equals(targetType) || Short.TYPE.equals(targetType)) {
            return Short.parseShort(value);
        }
        if (Integer.class.equals(targetType) || Integer.TYPE.equals(targetType)) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(targetType) || Long.TYPE.equals(targetType)) {
            return Long.parseLong(value);
        }
        if (Float.class.equals(targetType) || Float.TYPE.equals(targetType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals(targetType) || Double.TYPE.equals(targetType)) {
            return Double.parseDouble(value);
        }
        if (BigInteger.class.equals(targetType)) {
            return new BigInteger(value);
        }
        if (BigDecimal.class.equals(targetType)) {
            return new BigDecimal(value);
        }
        if (java.util.Date.class.equals(targetType)) {
            return DateUtils.parse(value);
        }
        if (Date.class.equals(targetType)) {
            return Date.valueOf(value);
        }
        if (Time.class.equals(targetType)) {
            return Time.valueOf(value);
        }
        if (Timestamp.class.equals(targetType)) {
            return Timestamp.valueOf(value);
        }
        if (LocalDate.class.equals(targetType)) {
            return LocalDate.parse(value);
        }
        if (LocalTime.class.equals(targetType)) {
            return LocalTime.parse(value);
        }
        if (LocalDateTime.class.equals(targetType)) {
            return LocalDateTime.parse(value);
        }
        return value;
    }

    private static Object convertArray(Object array, Class<?> targetType) {
        Object[] values = (Object[])array;
        Object convertedValuesArray = Array.newInstance(targetType.getComponentType(), values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(convertedValuesArray, i, ReflectionUtils.convertValue((String)values[i], targetType.getComponentType()));
        }
        return convertedValuesArray;
    }
}

