/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.registry;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.annotation.Priority;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.randomizers.misc.BooleanRandomizer;
import org.jeasy.random.randomizers.misc.LocaleRandomizer;
import org.jeasy.random.randomizers.misc.SkipRandomizer;
import org.jeasy.random.randomizers.misc.UUIDRandomizer;
import org.jeasy.random.randomizers.net.UriRandomizer;
import org.jeasy.random.randomizers.net.UrlRandomizer;
import org.jeasy.random.randomizers.number.AtomicIntegerRandomizer;
import org.jeasy.random.randomizers.number.AtomicLongRandomizer;
import org.jeasy.random.randomizers.number.BigDecimalRandomizer;
import org.jeasy.random.randomizers.number.BigIntegerRandomizer;
import org.jeasy.random.randomizers.number.ByteRandomizer;
import org.jeasy.random.randomizers.number.DoubleRandomizer;
import org.jeasy.random.randomizers.number.FloatRandomizer;
import org.jeasy.random.randomizers.number.IntegerRandomizer;
import org.jeasy.random.randomizers.number.LongRandomizer;
import org.jeasy.random.randomizers.number.ShortRandomizer;
import org.jeasy.random.randomizers.range.DateRangeRandomizer;
import org.jeasy.random.randomizers.range.SqlDateRangeRandomizer;
import org.jeasy.random.randomizers.text.CharacterRandomizer;
import org.jeasy.random.randomizers.text.StringRandomizer;
import org.jeasy.random.randomizers.time.CalendarRandomizer;
import org.jeasy.random.randomizers.time.SqlTimeRandomizer;
import org.jeasy.random.randomizers.time.SqlTimestampRandomizer;

@Priority(value=-4)
public class InternalRandomizerRegistry
implements RandomizerRegistry {
    private final Map<Class<?>, Randomizer<?>> randomizers = new HashMap();

    @Override
    public void init(EasyRandomParameters parameters) {
        long seed = parameters.getSeed();
        Charset charset = parameters.getCharset();
        this.randomizers.put(String.class, new StringRandomizer(charset, parameters.getStringLengthRange().getMin(), parameters.getStringLengthRange().getMax(), seed));
        CharacterRandomizer characterRandomizer = new CharacterRandomizer(charset, seed);
        this.randomizers.put(Character.class, characterRandomizer);
        this.randomizers.put(Character.TYPE, characterRandomizer);
        this.randomizers.put(Boolean.class, new BooleanRandomizer(seed));
        this.randomizers.put(Boolean.TYPE, new BooleanRandomizer(seed));
        this.randomizers.put(Byte.class, new ByteRandomizer(seed));
        this.randomizers.put(Byte.TYPE, new ByteRandomizer(seed));
        this.randomizers.put(Short.class, new ShortRandomizer(seed));
        this.randomizers.put(Short.TYPE, new ShortRandomizer(seed));
        this.randomizers.put(Integer.class, new IntegerRandomizer(seed));
        this.randomizers.put(Integer.TYPE, new IntegerRandomizer(seed));
        this.randomizers.put(Long.class, new LongRandomizer(seed));
        this.randomizers.put(Long.TYPE, new LongRandomizer(seed));
        this.randomizers.put(Double.class, new DoubleRandomizer(seed));
        this.randomizers.put(Double.TYPE, new DoubleRandomizer(seed));
        this.randomizers.put(Float.class, new FloatRandomizer(seed));
        this.randomizers.put(Float.TYPE, new FloatRandomizer(seed));
        this.randomizers.put(BigInteger.class, new BigIntegerRandomizer(seed));
        this.randomizers.put(BigDecimal.class, new BigDecimalRandomizer(seed));
        this.randomizers.put(AtomicLong.class, new AtomicLongRandomizer(seed));
        this.randomizers.put(AtomicInteger.class, new AtomicIntegerRandomizer(seed));
        Date minDate = Date.valueOf(parameters.getDateRange().getMin());
        Date maxDate = Date.valueOf(parameters.getDateRange().getMax());
        this.randomizers.put(java.util.Date.class, new DateRangeRandomizer(minDate, maxDate, seed));
        this.randomizers.put(Date.class, new SqlDateRangeRandomizer(new Date(minDate.getTime()), new Date(maxDate.getTime()), seed));
        this.randomizers.put(Time.class, new SqlTimeRandomizer(seed));
        this.randomizers.put(Timestamp.class, new SqlTimestampRandomizer(seed));
        this.randomizers.put(Calendar.class, new CalendarRandomizer(seed));
        this.randomizers.put(URL.class, new UrlRandomizer(seed));
        this.randomizers.put(URI.class, new UriRandomizer(seed));
        this.randomizers.put(Locale.class, new LocaleRandomizer(seed));
        this.randomizers.put(UUID.class, new UUIDRandomizer(seed));
        this.randomizers.put(Class.class, new SkipRandomizer());
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        return this.getRandomizer(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        return this.randomizers.get(type);
    }
}

