/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.collection;

import java.util.Collection;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.number.ByteRandomizer;

abstract class CollectionRandomizer<T>
implements Randomizer<Collection<T>> {
    final int nbElements;
    final Randomizer<T> delegate;

    CollectionRandomizer(Randomizer<T> delegate) {
        this(delegate, Math.abs(ByteRandomizer.aNewByteRandomizer().getRandomValue().byteValue()));
    }

    CollectionRandomizer(Randomizer<T> delegate, int nbElements) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.checkArguments(nbElements);
        this.nbElements = nbElements;
        this.delegate = delegate;
    }

    private void checkArguments(int nbElements) {
        if (nbElements < 0) {
            throw new IllegalArgumentException("The number of elements to generate must be >= 0");
        }
    }

    T getRandomElement() {
        return this.delegate.getRandomValue();
    }
}

