/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.registry;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.annotation.Priority;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.util.ReflectionUtils;

@Priority(value=-1)
public class CustomRandomizerRegistry
implements RandomizerRegistry {
    private final Map<Predicate<Field>, Randomizer<?>> customFieldRandomizersRegistry = new HashMap();
    private final Map<Class<?>, Randomizer<?>> customTypeRandomizersRegistry = new HashMap();

    @Override
    public void init(EasyRandomParameters parameters) {
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        for (Predicate<Field> fieldPredicate : this.customFieldRandomizersRegistry.keySet()) {
            if (!fieldPredicate.test(field)) continue;
            return this.customFieldRandomizersRegistry.get(fieldPredicate);
        }
        return this.getRandomizer(field.getType());
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> type) {
        Randomizer<?> randomizer = this.customTypeRandomizersRegistry.get(type);
        if (randomizer == null) {
            Class<?> wrapperType = type.isPrimitive() ? ReflectionUtils.getWrapperType(type) : type;
            randomizer = this.customTypeRandomizersRegistry.get(wrapperType);
        }
        return randomizer;
    }

    public <T, R> void registerRandomizer(Class<T> type, Randomizer<R> randomizer) {
        this.customTypeRandomizersRegistry.put(type, randomizer);
    }

    public void registerRandomizer(Predicate<Field> predicate, Randomizer<?> randomizer) {
        this.customFieldRandomizersRegistry.put(predicate, randomizer);
    }
}

