/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class LocalDateTimeRangeRandomizer
extends AbstractRangeRandomizer<LocalDateTime> {
    public LocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max) {
        super(min, max);
    }

    public LocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max, long seed) {
        super(min, max, seed);
    }

    public static LocalDateTimeRangeRandomizer aNewLocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max) {
        return new LocalDateTimeRangeRandomizer(min, max);
    }

    public static LocalDateTimeRangeRandomizer aNewLocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max, long seed) {
        return new LocalDateTimeRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((LocalDateTime)this.min).isAfter((ChronoLocalDateTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected LocalDateTime getDefaultMinValue() {
        return LocalDateTime.MIN;
    }

    @Override
    protected LocalDateTime getDefaultMaxValue() {
        return LocalDateTime.MAX;
    }

    @Override
    public LocalDateTime getRandomValue() {
        long minSeconds = ((LocalDateTime)this.min).toEpochSecond(ZoneOffset.UTC);
        long maxSeconds = ((LocalDateTime)this.max).toEpochSecond(ZoneOffset.UTC);
        long seconds = (long)this.nextDouble(minSeconds, maxSeconds);
        int minNanoSeconds = ((LocalDateTime)this.min).getNano();
        int maxNanoSeconds = ((LocalDateTime)this.max).getNano();
        long nanoSeconds = (long)this.nextDouble(minNanoSeconds, maxNanoSeconds);
        Instant instant = Instant.ofEpochSecond(seconds, nanoSeconds);
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }
}

