/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;
import org.jeasy.random.util.ReflectionUtils;

class CollectionPopulator {
    private final EasyRandom easyRandom;

    CollectionPopulator(EasyRandom easyRandom) {
        this.easyRandom = easyRandom;
    }

    Collection<?> getRandomCollection(Field field, RandomizationContext context) {
        ParameterizedType parameterizedType;
        Type type;
        int randomSize = this.getRandomCollectionSize(context.getParameters());
        Class<?> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        Collection<?> collection = ReflectionUtils.isInterface(fieldType) ? ReflectionUtils.getEmptyImplementationForCollectionInterface(fieldType) : ReflectionUtils.createEmptyCollectionForType(fieldType, randomSize);
        if (ReflectionUtils.isParameterizedType(fieldGenericType) && ReflectionUtils.isPopulatable(type = (parameterizedType = (ParameterizedType)fieldGenericType).getActualTypeArguments()[0])) {
            for (int i = 0; i < randomSize; ++i) {
                Object item = this.easyRandom.doPopulateBean((Class)type, context);
                collection.add(item);
            }
        }
        return collection;
    }

    private int getRandomCollectionSize(EasyRandomParameters parameters) {
        EasyRandomParameters.Range<Integer> collectionSizeRange = parameters.getCollectionSizeRange();
        return new IntegerRangeRandomizer(collectionSizeRange.getMin(), collectionSizeRange.getMax(), parameters.getSeed()).getRandomValue();
    }
}

