/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.time;

import java.time.LocalTime;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.time.HourRandomizer;
import org.jeasy.random.randomizers.time.MinuteRandomizer;

public class LocalTimeRandomizer
implements Randomizer<LocalTime> {
    private final HourRandomizer hourRandomizer;
    private final MinuteRandomizer minuteRandomizer;

    public LocalTimeRandomizer() {
        this.hourRandomizer = new HourRandomizer();
        this.minuteRandomizer = new MinuteRandomizer();
    }

    public LocalTimeRandomizer(long seed) {
        this.hourRandomizer = new HourRandomizer(seed);
        this.minuteRandomizer = new MinuteRandomizer(seed);
    }

    public static LocalTimeRandomizer aNewLocalTimeRandomizer() {
        return new LocalTimeRandomizer();
    }

    public static LocalTimeRandomizer aNewLocalTimeRandomizer(long seed) {
        return new LocalTimeRandomizer(seed);
    }

    @Override
    public LocalTime getRandomValue() {
        int randomHour = this.hourRandomizer.getRandomValue();
        int randomMinute = this.minuteRandomizer.getRandomValue();
        int randomSecond = this.minuteRandomizer.getRandomValue();
        return LocalTime.of(randomHour, randomMinute, randomSecond);
    }
}

