/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.chrono.ChronoLocalDateTime;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;
import org.jeasy.random.randomizers.range.LocalDateRangeRandomizer;
import org.jeasy.random.randomizers.range.LocalTimeRangeRandomizer;

public class LocalDateTimeRangeRandomizer
extends AbstractRangeRandomizer<LocalDateTime> {
    private final LocalDateRangeRandomizer localDateRangeRandomizer;
    private final LocalTimeRangeRandomizer localTimeRangeRandomizer;

    public LocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max) {
        super(min, max);
        this.localDateRangeRandomizer = new LocalDateRangeRandomizer(((LocalDateTime)this.min).toLocalDate(), ((LocalDateTime)this.max).toLocalDate());
        this.localTimeRangeRandomizer = new LocalTimeRangeRandomizer(((LocalDateTime)this.min).toLocalTime(), ((LocalDateTime)this.max).toLocalTime());
    }

    public LocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max, long seed) {
        super(min, max, seed);
        this.localDateRangeRandomizer = new LocalDateRangeRandomizer(((LocalDateTime)this.min).toLocalDate(), ((LocalDateTime)this.max).toLocalDate(), seed);
        this.localTimeRangeRandomizer = new LocalTimeRangeRandomizer(((LocalDateTime)this.min).toLocalTime(), ((LocalDateTime)this.max).toLocalTime(), seed);
    }

    public static LocalDateTimeRangeRandomizer aNewLocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max) {
        return new LocalDateTimeRangeRandomizer(min, max);
    }

    public static LocalDateTimeRangeRandomizer aNewLocalDateTimeRangeRandomizer(LocalDateTime min, LocalDateTime max, long seed) {
        return new LocalDateTimeRangeRandomizer(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((LocalDateTime)this.min).isAfter((ChronoLocalDateTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected LocalDateTime getDefaultMinValue() {
        return LocalDateTime.MIN;
    }

    @Override
    protected LocalDateTime getDefaultMaxValue() {
        return LocalDateTime.MAX;
    }

    @Override
    public LocalDateTime getRandomValue() {
        LocalDate randomLocalDate = this.localDateRangeRandomizer.getRandomValue();
        LocalTime randomLocalTime = this.localTimeRangeRandomizer.getRandomValue();
        return LocalDateTime.of(randomLocalDate, randomLocalTime);
    }
}

