/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.util;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

abstract class ClassGraphFacade {
    private static final ConcurrentHashMap<Class<?>, List<Class<?>>> typeToConcreteSubTypes = new ConcurrentHashMap();
    private static final ScanResult scanResult = new ClassGraph().enableSystemJarsAndModules().enableClassInfo().scan();

    ClassGraphFacade() {
    }

    public static <T> List<Class<?>> getPublicConcreteSubTypesOf(Class<T> type) {
        return typeToConcreteSubTypes.computeIfAbsent(type, ClassGraphFacade::searchForPublicConcreteSubTypesOf);
    }

    private static <T> List<Class<?>> searchForPublicConcreteSubTypesOf(Class<T> type) {
        String typeName = type.getCanonicalName();
        ClassInfoList subTypes = type.isInterface() ? scanResult.getClassesImplementing(typeName) : scanResult.getSubclasses(typeName);
        List loadedSubTypes = subTypes.filter(subType -> subType.isPublic() && !subType.isAbstract()).loadClasses(true);
        return Collections.unmodifiableList(loadedSubTypes);
    }
}

