/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.range.DoubleRangeRandomizer;

public class BigDecimalRangeRandomizer
implements Randomizer<BigDecimal> {
    private final DoubleRangeRandomizer delegate;
    private Integer scale;

    public BigDecimalRangeRandomizer(Double min, Double max) {
        this.delegate = new DoubleRangeRandomizer(min, max);
    }

    public BigDecimalRangeRandomizer(Double min, Double max, long seed) {
        this.delegate = new DoubleRangeRandomizer(min, max, seed);
    }

    public BigDecimalRangeRandomizer(Double min, Double max, Integer scale) {
        this.delegate = new DoubleRangeRandomizer(min, max);
        this.scale = scale;
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max) {
        return new BigDecimalRangeRandomizer(min, max);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, long seed) {
        return new BigDecimalRangeRandomizer(min, max, seed);
    }

    public static BigDecimalRangeRandomizer aNewBigDecimalRangeRandomizer(Double min, Double max, Integer scale) {
        return new BigDecimalRangeRandomizer(min, max, scale);
    }

    @Override
    public BigDecimal getRandomValue() {
        Double delegateRandomValue = this.delegate.getRandomValue();
        BigDecimal randomValue = new BigDecimal(delegateRandomValue);
        if (this.scale != null) {
            randomValue = randomValue.setScale((int)this.scale, RoundingMode.HALF_UP);
        }
        return randomValue;
    }
}

