/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.misc;

import org.jeasy.random.api.Randomizer;
import org.jeasy.random.randomizers.AbstractRandomizer;

public class OptionalRandomizer<T>
extends AbstractRandomizer<T> {
    private static final int MAX_PERCENT = 100;
    private final Randomizer<T> delegate;
    private final int optionalPercent;

    public OptionalRandomizer(Randomizer<T> delegate, int optionalPercent) {
        this.delegate = delegate;
        this.optionalPercent = optionalPercent > 100 ? 100 : (optionalPercent < 0 ? 0 : optionalPercent);
    }

    public static <T> Randomizer<T> aNewOptionalRandomizer(Randomizer<T> delegate, int optionalPercent) {
        return new OptionalRandomizer<T>(delegate, optionalPercent);
    }

    @Override
    public T getRandomValue() {
        int randomPercent = this.random.nextInt(100);
        if (randomPercent <= this.optionalPercent) {
            return this.delegate.getRandomValue();
        }
        return null;
    }
}

