/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.api.ObjectFactory;
import org.jeasy.random.util.ReflectionUtils;

class MapPopulator {
    private final EasyRandom easyRandom;
    private final ObjectFactory objectFactory;

    MapPopulator(EasyRandom easyRandom, ObjectFactory objectFactory) {
        this.easyRandom = easyRandom;
        this.objectFactory = objectFactory;
    }

    Map<?, ?> getRandomMap(Field field, RandomizationContext context) {
        EnumMap map;
        int randomSize = this.easyRandom.getRandomCollectionSize();
        Class<EnumMap> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        if (ReflectionUtils.isInterface(fieldType)) {
            map = this.getEmptyImplementationForMapInterface(fieldType);
        } else {
            try {
                map = (EnumMap)fieldType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                if (fieldType.isAssignableFrom(EnumMap.class)) {
                    if (ReflectionUtils.isParameterizedType(fieldGenericType)) {
                        Type type = ((ParameterizedType)fieldGenericType).getActualTypeArguments()[0];
                        map = new EnumMap((Class)type);
                    }
                    return null;
                }
                map = (Map)this.objectFactory.createInstance(fieldType, context);
            }
        }
        if (ReflectionUtils.isParameterizedType(fieldGenericType)) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldGenericType;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            if (ReflectionUtils.isPopulatable(keyType) && ReflectionUtils.isPopulatable(valueType)) {
                for (int index = 0; index < randomSize; ++index) {
                    Object randomKey = this.easyRandom.doPopulateBean((Class)keyType, context);
                    Object randomValue = this.easyRandom.doPopulateBean((Class)valueType, context);
                    if (randomKey == null) continue;
                    map.put(randomKey, randomValue);
                }
            }
        }
        return map;
    }

    Map<?, ?> getEmptyImplementationForMapInterface(Class<?> mapInterface) {
        AbstractMap map = new HashMap();
        if (ConcurrentNavigableMap.class.isAssignableFrom(mapInterface)) {
            map = new ConcurrentSkipListMap();
        } else if (ConcurrentMap.class.isAssignableFrom(mapInterface)) {
            map = new ConcurrentHashMap();
        } else if (NavigableMap.class.isAssignableFrom(mapInterface)) {
            map = new TreeMap();
        } else if (SortedMap.class.isAssignableFrom(mapInterface)) {
            map = new TreeMap();
        }
        return map;
    }
}

