/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TransferQueue;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.util.ReflectionUtils;
import org.objenesis.ObjenesisStd;

class CollectionPopulator {
    private final EasyRandom easyRandom;

    CollectionPopulator(EasyRandom easyRandom) {
        this.easyRandom = easyRandom;
    }

    Collection<?> getRandomCollection(Field field, RandomizationContext context) {
        ParameterizedType parameterizedType;
        Type type;
        int randomSize = this.easyRandom.getRandomCollectionSize();
        Class<?> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        Collection<?> collection = ReflectionUtils.isInterface(fieldType) ? this.getEmptyImplementationForCollectionInterface(fieldType) : this.createEmptyCollectionForType(fieldType, randomSize);
        if (ReflectionUtils.isParameterizedType(fieldGenericType) && ReflectionUtils.isPopulatable(type = (parameterizedType = (ParameterizedType)fieldGenericType).getActualTypeArguments()[0])) {
            for (int i = 0; i < randomSize; ++i) {
                Object item = this.easyRandom.doPopulateBean((Class)type, context);
                collection.add(item);
            }
        }
        return collection;
    }

    Collection<?> createEmptyCollectionForType(Class<?> fieldType, int initialSize) {
        Collection collection;
        this.rejectUnsupportedTypes(fieldType);
        try {
            collection = (ArrayBlockingQueue)fieldType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            collection = fieldType.equals(ArrayBlockingQueue.class) ? new ArrayBlockingQueue(initialSize) : (Collection)new ObjenesisStd().newInstance(fieldType);
        }
        return collection;
    }

    private void rejectUnsupportedTypes(Class<?> type) {
        if (type.equals(SynchronousQueue.class)) {
            throw new UnsupportedOperationException(SynchronousQueue.class.getName() + " type is not supported");
        }
        if (type.equals(DelayQueue.class)) {
            throw new UnsupportedOperationException(DelayQueue.class.getName() + " type is not supported");
        }
    }

    Collection<?> getEmptyImplementationForCollectionInterface(Class<?> collectionInterface) {
        AbstractCollection collection = new ArrayList();
        if (List.class.isAssignableFrom(collectionInterface)) {
            collection = new ArrayList();
        } else if (NavigableSet.class.isAssignableFrom(collectionInterface)) {
            collection = new TreeSet();
        } else if (SortedSet.class.isAssignableFrom(collectionInterface)) {
            collection = new TreeSet();
        } else if (Set.class.isAssignableFrom(collectionInterface)) {
            collection = new HashSet();
        } else if (BlockingDeque.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedBlockingDeque();
        } else if (Deque.class.isAssignableFrom(collectionInterface)) {
            collection = new ArrayDeque();
        } else if (TransferQueue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedTransferQueue();
        } else if (BlockingQueue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedBlockingQueue();
        } else if (Queue.class.isAssignableFrom(collectionInterface)) {
            collection = new LinkedList();
        }
        return collection;
    }
}

