/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Array;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.api.ContextAwareRandomizer;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerProvider;

class ArrayPopulator {
    private final EasyRandom easyRandom;
    private final RandomizerProvider randomizerProvider;

    ArrayPopulator(EasyRandom easyRandom, RandomizerProvider randomizerProvider) {
        this.easyRandom = easyRandom;
        this.randomizerProvider = randomizerProvider;
    }

    <T> Object getRandomArray(Class<?> fieldType, RandomizationContext context) {
        Class<?> componentType = fieldType.getComponentType();
        if (componentType.isPrimitive()) {
            return this.getRandomPrimitiveArray(componentType, context);
        }
        int randomSize = this.easyRandom.getRandomCollectionSize();
        Object[] itemsList = (Object[])Array.newInstance(componentType, randomSize);
        for (int i = 0; i < randomSize; ++i) {
            itemsList[i] = this.easyRandom.doPopulateBean(fieldType.getComponentType(), context);
        }
        return itemsList;
    }

    Object getRandomPrimitiveArray(Class<?> primitiveType, RandomizationContext context) {
        int randomSize = Math.abs((byte)this.easyRandom.nextInt());
        Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByType(primitiveType, context);
        if (randomizer instanceof ContextAwareRandomizer) {
            ((ContextAwareRandomizer)randomizer).setRandomizerContext(context);
        }
        Object result = Array.newInstance(primitiveType, randomSize);
        for (int index = 0; index < randomSize; ++index) {
            Array.set(result, index, randomizer.getRandomValue());
        }
        return result;
    }
}

