/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking.dtaus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.jdtaus.core.container.ContainerFactory;

public final class LogicalFileType
implements Serializable {
    public static final LogicalFileType LK = new LogicalFileType("LK", true, false, true, false);
    public static final LogicalFileType GK = new LogicalFileType("GK", false, true, true, false);
    public static final LogicalFileType LB = new LogicalFileType("LB", true, false, false, true);
    public static final LogicalFileType GB = new LogicalFileType("GB", false, true, false, true);
    private static final LogicalFileType[] SUPPORTED = new LogicalFileType[]{GB, GK, LB, LK};
    private static final long serialVersionUID = 5932863701674153762L;
    private String code;
    private boolean debitAllowed;
    private boolean remittanceAllowed;
    private boolean sendByCustomer;
    private boolean sendByBank;

    private LogicalFileType(String code, boolean debitAllowed, boolean remittanceAllowed, boolean sendByCustomer, boolean sendByBank) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        this.code = code;
        this.debitAllowed = debitAllowed;
        this.remittanceAllowed = remittanceAllowed;
        this.sendByBank = sendByBank;
        this.sendByCustomer = sendByCustomer;
    }

    public static LogicalFileType valueOf(String code) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        for (int i = SUPPORTED.length - 1; i >= 0; --i) {
            if (!SUPPORTED[i].getCode().equals(code)) continue;
            return SUPPORTED[i];
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isDebitAllowed() {
        return this.debitAllowed;
    }

    public boolean isRemittanceAllowed() {
        return this.remittanceAllowed;
    }

    public boolean isSendByCustomer() {
        return this.sendByCustomer;
    }

    public boolean isSendByBank() {
        return this.sendByBank;
    }

    public String getShortDescription(Locale locale) {
        Locale l;
        String shortDescription = "";
        Locale locale2 = l = locale == null ? Locale.getDefault() : locale;
        if ("LK".equals(this.getCode())) {
            shortDescription = this.getLogicalFileType_LKMessage(l);
        } else if ("GK".equals(this.getCode())) {
            shortDescription = this.getLogicalFileType_GKMessage(l);
        } else if ("LB".equals(this.getCode())) {
            shortDescription = this.getLogicalFileType_LBMessage(l);
        } else if ("GB".equals(this.getCode())) {
            shortDescription = this.getLogicalFileType_GBMessage(l);
        }
        return shortDescription;
    }

    public static LogicalFileType[] search(boolean debitAllowed, boolean remittanceAllowed, boolean sendByBank, boolean sendByCustomer) {
        return LogicalFileType.searchLogicalFileTypes(debitAllowed, remittanceAllowed, sendByBank, sendByCustomer);
    }

    public static LogicalFileType[] searchLogicalFileTypes(Boolean debitAllowed, Boolean remittanceAllowed, Boolean sendByBank, Boolean sendByCustomer) {
        ArrayList<LogicalFileType> c = new ArrayList<LogicalFileType>(SUPPORTED.length);
        for (int i = SUPPORTED.length - 1; i >= 0; --i) {
            if (debitAllowed != null && SUPPORTED[i].isDebitAllowed() != debitAllowed.booleanValue() || remittanceAllowed != null && SUPPORTED[i].isRemittanceAllowed() != remittanceAllowed.booleanValue() || sendByBank != null && SUPPORTED[i].isSendByBank() != sendByBank.booleanValue() || sendByCustomer != null && SUPPORTED[i].isSendByCustomer() != sendByCustomer.booleanValue()) continue;
            c.add(SUPPORTED[i]);
        }
        return c.toArray(new LogicalFileType[c.size()]);
    }

    private String internalString() {
        return new StringBuffer(200).append('{').append("code=").append(this.code).append(", debitAllowed=").append(this.debitAllowed).append(", remittanceAllowed=").append(this.remittanceAllowed).append(", sendByCustomer=").append(this.sendByCustomer).append(", sendByBank=").append(this.sendByBank).append('}').toString();
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = o == this;
        if (!ret && o instanceof LogicalFileType) {
            LogicalFileType that = (LogicalFileType)o;
            ret = this.isDebitAllowed() == that.isDebitAllowed() && this.isRemittanceAllowed() == that.isRemittanceAllowed() && this.isSendByBank() == that.isSendByBank() && this.isSendByCustomer() == that.isSendByCustomer() && (this.getCode() == null ? that.getCode() == null : this.getCode().equals(that.getCode()));
        }
        return ret;
    }

    public int hashCode() {
        return this.internalString().hashCode();
    }

    public String toString() {
        return super.toString() + this.internalString();
    }

    private String getLogicalFileType_GBMessage(Locale locale) {
        return ContainerFactory.getContainer().getMessage((Object)this, "logicalFileType_GB", locale, null);
    }

    private String getLogicalFileType_LBMessage(Locale locale) {
        return ContainerFactory.getContainer().getMessage((Object)this, "logicalFileType_LB", locale, null);
    }

    private String getLogicalFileType_GKMessage(Locale locale) {
        return ContainerFactory.getContainer().getMessage((Object)this, "logicalFileType_GK", locale, null);
    }

    private String getLogicalFileType_LKMessage(Locale locale) {
        return ContainerFactory.getContainer().getMessage((Object)this, "logicalFileType_LK", locale, null);
    }
}

