/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Referenznummer10
extends Number
implements Comparable {
    public static final int ELECTRONIC_FORMAT = 5001;
    public static final int LETTER_FORMAT = 5002;
    public static final int MAX_DIGITS = 10;
    public static final int MAX_CHARACTERS = 13;
    private static final double[] EXP10 = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static final long serialVersionUID = -72660089907415650L;
    private static volatile Reference cacheReference = new SoftReference<Object>(null);
    private long ref;

    private Referenznummer10(Number referenceCode) {
        if (!Referenznummer10.checkReferenznummer10(referenceCode)) {
            throw new IllegalArgumentException(referenceCode.toString());
        }
        this.ref = referenceCode.longValue();
    }

    public static Referenznummer10 parse(String referenceCode, ParsePosition pos) {
        int i;
        if (referenceCode == null) {
            throw new NullPointerException("referenceCode");
        }
        if (pos == null) {
            throw new NullPointerException("pos");
        }
        Referenznummer10 ret = null;
        boolean sawSpace = false;
        boolean failed = false;
        ParsePosition fmtPos = new ParsePosition(0);
        int len = referenceCode.length();
        int startIndex = pos.getIndex();
        int maxIndex = startIndex + 13;
        StringBuffer digits = new StringBuffer(10);
        int mode = 5001;
        int part = 0;
        int partStart = 0;
        int partEnd = 2;
        int digit = 0;
        for (i = startIndex; i < len && i < maxIndex && digits.length() < 10; ++i) {
            char c = referenceCode.charAt(i);
            if (Character.isDigit(c)) {
                sawSpace = false;
                if (mode == 5002) {
                    if (digit < partStart || digit > partEnd) {
                        failed = true;
                    } else {
                        digits.append(c);
                    }
                } else {
                    digits.append(c);
                }
                ++digit;
            } else if (c == ' ') {
                if (sawSpace || i == startIndex || mode == 5001 && digit != 3) {
                    failed = true;
                } else {
                    mode = 5002;
                    switch (part) {
                        case 0: {
                            partStart = 3;
                            partEnd = 5;
                            break;
                        }
                        case 1: {
                            partStart = 6;
                            partEnd = 8;
                            break;
                        }
                        case 2: {
                            partStart = 9;
                            partEnd = 9;
                            break;
                        }
                        default: {
                            failed = true;
                        }
                    }
                    ++part;
                    if (digit < partStart || digit > partEnd) {
                        failed = true;
                    }
                }
                sawSpace = true;
            } else {
                failed = true;
            }
            if (!failed) continue;
            pos.setErrorIndex(i);
            break;
        }
        if (!failed) {
            Number num = new DecimalFormat("##########").parse(digits.toString(), fmtPos);
            if (num != null && fmtPos.getErrorIndex() == -1) {
                String key = num.toString();
                ret = (Referenznummer10)Referenznummer10.getCache().get(key);
                if (ret == null) {
                    if (!Referenznummer10.checkReferenznummer10(num)) {
                        pos.setErrorIndex(startIndex);
                        ret = null;
                    } else {
                        pos.setIndex(i);
                        ret = new Referenznummer10(num);
                        Referenznummer10.getCache().put(key, ret);
                    }
                } else {
                    pos.setIndex(i);
                }
            } else {
                pos.setErrorIndex(startIndex);
            }
        }
        return ret;
    }

    public static Referenznummer10 parse(String referenceCode) throws ParseException {
        if (referenceCode == null) {
            throw new NullPointerException("referenceCode");
        }
        Referenznummer10 ref = (Referenznummer10)Referenznummer10.getCache().get(referenceCode);
        if (ref == null) {
            ParsePosition pos = new ParsePosition(0);
            ref = Referenznummer10.parse(referenceCode, pos);
            if (ref == null || pos.getErrorIndex() != -1 || pos.getIndex() < referenceCode.length()) {
                throw new ParseException(referenceCode, pos.getErrorIndex() != -1 ? pos.getErrorIndex() : pos.getIndex());
            }
            Referenznummer10.getCache().put(referenceCode, ref);
        }
        return ref;
    }

    public static Referenznummer10 valueOf(Number referenceCode) {
        if (referenceCode == null) {
            throw new NullPointerException("referenceCode");
        }
        String key = referenceCode.toString();
        Referenznummer10 ret = (Referenznummer10)Referenznummer10.getCache().get(key);
        if (ret == null) {
            ret = new Referenznummer10(referenceCode);
            Referenznummer10.getCache().put(key, ret);
        }
        return ret;
    }

    public static Referenznummer10 valueOf(String referenceCode) {
        try {
            return Referenznummer10.parse(referenceCode);
        }
        catch (ParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(referenceCode).initCause(e);
        }
    }

    public static boolean checkReferenznummer10(Number referenceCode) {
        boolean valid;
        boolean bl = valid = referenceCode != null;
        if (valid) {
            long num = referenceCode.longValue();
            valid = num >= 0L && num < 10000000000L;
        }
        return valid;
    }

    public int intValue() {
        return (int)this.ref;
    }

    public long longValue() {
        return this.ref;
    }

    public float floatValue() {
        return this.ref;
    }

    public double doubleValue() {
        return this.ref;
    }

    public StringBuffer format(int style, StringBuffer toAppendTo) {
        if (toAppendTo == null) {
            throw new NullPointerException("toAppendTo");
        }
        if (style != 5001 && style != 5002) {
            throw new IllegalArgumentException(Integer.toString(style));
        }
        if (this.ref == 0L) {
            toAppendTo.append('0');
        } else {
            int[] digits = Referenznummer10.toDigits(this.ref);
            int lastDigit = 0;
            for (int i = digits.length - 1; i >= 0; --i) {
                if (digits[i] != 0 || lastDigit > 0) {
                    toAppendTo.append(digits[i]);
                    ++lastDigit;
                }
                if (style != 5002 || lastDigit != 3 && lastDigit != 6 && lastDigit != 9) continue;
                toAppendTo.append(' ');
            }
        }
        return toAppendTo;
    }

    public String format(int style) {
        return this.format(style, new StringBuffer()).toString();
    }

    public static String toString(Referenznummer10 referenznummer10) {
        if (referenznummer10 == null) {
            throw new NullPointerException("referenznummer10");
        }
        return referenznummer10.format(5001);
    }

    private static int[] toDigits(long number) {
        int[] ret = new int[10];
        for (int i = 9; i >= 0; --i) {
            long subst = 0L;
            for (int j = i + 1; j < 10; ++j) {
                subst = (long)((double)subst + (double)ret[j] * EXP10[j]);
            }
            ret[i] = (int)Math.floor((double)(number - subst) / EXP10[i]);
        }
        return ret;
    }

    private String internalString() {
        return new StringBuffer(500).append("{referenceNumber=").append(this.ref).append('}').toString();
    }

    private static Map getCache() {
        Map cache = (Map)cacheReference.get();
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap(1024));
            cacheReference = new SoftReference(cache);
        }
        return cache;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (!(o instanceof Referenznummer10)) {
            throw new ClassCastException(o.getClass().getName());
        }
        int result = 0;
        Referenznummer10 that = (Referenznummer10)o;
        if (!this.equals(that)) {
            result = this.ref > that.ref ? 1 : -1;
        }
        return result;
    }

    public boolean equals(Object o) {
        boolean equal;
        boolean bl = equal = o == this;
        if (!equal && o instanceof Referenznummer10) {
            equal = this.ref == ((Referenznummer10)o).ref;
        }
        return equal;
    }

    public int hashCode() {
        return (int)(this.ref ^ this.ref >>> 32);
    }

    public String toString() {
        return super.toString() + this.internalString();
    }
}

