/*
 * Decompiled with CFR 0.152.
 */
package org.jdtaus.banking;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import org.jdtaus.banking.Bankleitzahl;

public class BankleitzahlInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7251689236798391940L;
    private static final int[] FIELD_TO_OFFSET = new int[]{0, 8, 9, 67, 72, 107, 134, 139, 150, 152, 158, 159, 160};
    private static final int[] FIELD_TO_LENGTH = new int[]{8, 1, 58, 5, 35, 27, 5, 11, 2, 6, 1, 1, 8};
    private static final int[] FIELD_TO_ENDOFFSET = new int[]{FIELD_TO_OFFSET[0] + FIELD_TO_LENGTH[0], FIELD_TO_OFFSET[1] + FIELD_TO_LENGTH[1], FIELD_TO_OFFSET[2] + FIELD_TO_LENGTH[2], FIELD_TO_OFFSET[3] + FIELD_TO_LENGTH[3], FIELD_TO_OFFSET[4] + FIELD_TO_LENGTH[4], FIELD_TO_OFFSET[5] + FIELD_TO_LENGTH[5], FIELD_TO_OFFSET[6] + FIELD_TO_LENGTH[6], FIELD_TO_OFFSET[7] + FIELD_TO_LENGTH[7], FIELD_TO_OFFSET[8] + FIELD_TO_LENGTH[8], FIELD_TO_OFFSET[9] + FIELD_TO_LENGTH[9], FIELD_TO_OFFSET[10] + FIELD_TO_LENGTH[10], FIELD_TO_OFFSET[11] + FIELD_TO_LENGTH[11], FIELD_TO_OFFSET[12] + FIELD_TO_LENGTH[12]};
    private Bankleitzahl bankCode;
    private boolean headOffice;
    private String name;
    private int postalCode = -1;
    private String city;
    private String description;
    private int panInstituteNumber = -1;
    private String bic;
    private String validationLabel;
    private Integer serialNumber;
    private char changeLabel;
    private boolean markedForDeletion;
    private Bankleitzahl replacingBankCode;
    private Integer ibanRuleLabel;
    private Integer ibanRuleVersion;
    private Date creationDate;
    private Date modificationDate;
    private Date deletionDate;

    public Bankleitzahl getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(Bankleitzahl value) {
        this.bankCode = value;
    }

    public boolean isHeadOffice() {
        return this.headOffice;
    }

    public void setHeadOffice(boolean value) {
        this.headOffice = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public int getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(int value) {
        this.postalCode = value;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String value) {
        this.city = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public int getPanInstituteNumber() {
        return this.panInstituteNumber;
    }

    public void setPanInstituteNumber(int value) {
        this.panInstituteNumber = value;
    }

    public String getBic() {
        return this.bic;
    }

    public void setBic(String value) {
        this.bic = value;
    }

    public String getValidationLabel() {
        return this.validationLabel;
    }

    public void setValidationLabel(String value) {
        this.validationLabel = value;
    }

    public Integer getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(Integer value) {
        this.serialNumber = value;
    }

    public char getChangeLabel() {
        return this.changeLabel;
    }

    public void setChangeLabel(char value) {
        this.changeLabel = value;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean value) {
        this.markedForDeletion = value;
    }

    public Bankleitzahl getReplacingBankCode() {
        return this.replacingBankCode;
    }

    public void setReplacingBankCode(Bankleitzahl value) {
        this.replacingBankCode = value;
    }

    public Integer getIbanRuleLabel() {
        return this.ibanRuleLabel;
    }

    public void setIbanRuleLabel(Integer value) {
        this.ibanRuleLabel = value;
    }

    public Integer getIbanRuleVersion() {
        return this.ibanRuleVersion;
    }

    public void setIbanRuleVersion(Integer value) {
        this.ibanRuleVersion = value;
    }

    public Date getCreationDate() {
        return (Date)(this.creationDate != null ? this.creationDate.clone() : null);
    }

    public void setCreationDate(Date value) {
        this.creationDate = (Date)(value != null ? value.clone() : null);
    }

    public Date getModificationDate() {
        return (Date)(this.modificationDate != null ? this.modificationDate.clone() : null);
    }

    public void setModificationDate(Date value) {
        this.modificationDate = (Date)(value != null ? value.clone() : null);
    }

    public Date getDeletionDate() {
        return (Date)(this.deletionDate != null ? this.deletionDate.clone() : null);
    }

    public void setDeletionDate(Date value) {
        this.deletionDate = (Date)(value != null ? value.clone() : null);
    }

    public void parse(String line) {
        if (line == null) {
            throw new NullPointerException("line");
        }
        DecimalFormat plzFmt = new DecimalFormat("00000");
        DecimalFormat serFmt = new DecimalFormat("000000");
        DecimalFormat blzFmt = new DecimalFormat("00000000");
        try {
            this.bankCode = Bankleitzahl.parse(line.substring(FIELD_TO_OFFSET[0], FIELD_TO_ENDOFFSET[0]).trim());
            this.headOffice = "1".equals(line.substring(FIELD_TO_OFFSET[1], FIELD_TO_ENDOFFSET[1]));
            this.name = line.substring(FIELD_TO_OFFSET[2], FIELD_TO_ENDOFFSET[2]).trim();
            this.postalCode = plzFmt.parse(line.substring(FIELD_TO_OFFSET[3], FIELD_TO_ENDOFFSET[3]).trim()).intValue();
            this.city = line.substring(FIELD_TO_OFFSET[4], FIELD_TO_ENDOFFSET[4]).trim();
            this.description = line.substring(FIELD_TO_OFFSET[5], FIELD_TO_ENDOFFSET[5]).trim();
            String field = line.substring(FIELD_TO_OFFSET[6], FIELD_TO_ENDOFFSET[6]).trim();
            this.panInstituteNumber = field.length() > 0 ? plzFmt.parse(field).intValue() : 0;
            this.bic = line.substring(FIELD_TO_OFFSET[7], FIELD_TO_ENDOFFSET[7]).trim();
            this.validationLabel = line.substring(FIELD_TO_OFFSET[8], FIELD_TO_ENDOFFSET[8]).trim();
            this.serialNumber = new Integer(serFmt.parse(line.substring(FIELD_TO_OFFSET[9], FIELD_TO_ENDOFFSET[9]).trim()).intValue());
            this.changeLabel = line.substring(FIELD_TO_OFFSET[10], FIELD_TO_ENDOFFSET[10]).toCharArray()[0];
            this.markedForDeletion = "1".equals(line.substring(FIELD_TO_OFFSET[11], FIELD_TO_ENDOFFSET[11]));
            Number blz = blzFmt.parse(line.substring(FIELD_TO_OFFSET[12], FIELD_TO_ENDOFFSET[12]).trim());
            this.replacingBankCode = blz.intValue() != 0 ? Bankleitzahl.valueOf(blz) : null;
        }
        catch (ParseException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(line).initCause(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw (IllegalArgumentException)new IllegalArgumentException(line).initCause(e);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = o == this;
        if (!ret && o instanceof BankleitzahlInfo) {
            BankleitzahlInfo that = (BankleitzahlInfo)o;
            ret = this.serialNumber == null ? that.serialNumber == null : this.serialNumber.equals(that.serialNumber);
        }
        return ret;
    }

    public int hashCode() {
        return this.serialNumber == null ? 0 : this.serialNumber;
    }

    public String toString() {
        return super.toString() + this.internalString();
    }

    private String internalString() {
        return new StringBuffer(500).append('{').append("headOffice=").append(this.headOffice).append(", bankCode=").append(this.bankCode).append(", name=").append(this.name).append(", bic=").append(this.bic).append(", changeLabel=").append(this.changeLabel).append(", city=").append(this.city).append(", markedForDeletion=").append(this.markedForDeletion).append(", panInstituteNumber=").append(this.panInstituteNumber).append(", postalCode=").append(this.postalCode).append(", replacingBankCode=").append(this.replacingBankCode).append(", serialNumber=").append(this.serialNumber).append(", description=").append(this.description).append(", validationLabel=").append(this.validationLabel).append(", ibanRuleLabel=").append(this.ibanRuleLabel).append(", ibanRuleVersion=").append(this.ibanRuleVersion).append(", creationDate=").append(this.creationDate).append(", modificationDate=").append(this.modificationDate).append(", deletionDate=").append(this.deletionDate).append('}').toString();
    }
}

