/*
 * Decompiled with CFR 0.152.
 */
package org.jdeferred.impl;

import org.jdeferred.DoneCallback;
import org.jdeferred.DonePipe;
import org.jdeferred.FailCallback;
import org.jdeferred.FailPipe;
import org.jdeferred.ProgressCallback;
import org.jdeferred.ProgressPipe;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class PipedPromise<D, F, P, D_OUT, F_OUT, P_OUT>
extends DeferredObject<D_OUT, F_OUT, P_OUT>
implements Promise<D_OUT, F_OUT, P_OUT> {
    public PipedPromise(Promise<D, F, P> promise, final DonePipe<D, D_OUT, F_OUT, P_OUT> doneFilter, final FailPipe<F, D_OUT, F_OUT, P_OUT> failFilter, final ProgressPipe<P, D_OUT, F_OUT, P_OUT> progressFilter) {
        promise.done(new DoneCallback<D>(){

            @Override
            public void onDone(D result) {
                if (doneFilter != null) {
                    PipedPromise.this.pipe(doneFilter.pipeDone(result));
                } else {
                    PipedPromise.this.resolve(result);
                }
            }
        }).fail(new FailCallback<F>(){

            @Override
            public void onFail(F result) {
                if (failFilter != null) {
                    PipedPromise.this.pipe(failFilter.pipeFail(result));
                } else {
                    PipedPromise.this.reject(result);
                }
            }
        }).progress(new ProgressCallback<P>(){

            @Override
            public void onProgress(P progress) {
                if (progressFilter != null) {
                    PipedPromise.this.pipe(progressFilter.pipeProgress(progress));
                } else {
                    PipedPromise.this.notify(progress);
                }
            }
        });
    }

    protected Promise<D_OUT, F_OUT, P_OUT> pipe(Promise<D_OUT, F_OUT, P_OUT> promise) {
        promise.done(new DoneCallback<D_OUT>(){

            @Override
            public void onDone(D_OUT result) {
                PipedPromise.this.resolve(result);
            }
        }).fail(new FailCallback<F_OUT>(){

            @Override
            public void onFail(F_OUT result) {
                PipedPromise.this.reject(result);
            }
        }).progress(new ProgressCallback<P_OUT>(){

            @Override
            public void onProgress(P_OUT progress) {
                PipedPromise.this.notify(progress);
            }
        });
        return promise;
    }
}

