/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing;

import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.testing.EmbeddedH2JdbiRule;
import org.jdbi.v3.testing.EmbeddedPostgresJdbiRule;
import org.jdbi.v3.testing.EmbeddedSqliteJdbiRule;
import org.jdbi.v3.testing.ExternalPostgresJdbiRule;
import org.jdbi.v3.testing.Migration;
import org.junit.rules.ExternalResource;

public abstract class JdbiRule
extends ExternalResource {
    private final List<JdbiPlugin> plugins = new ArrayList<JdbiPlugin>();
    private final ReentrantLock lock = new ReentrantLock();
    private volatile DataSource dataSource;
    private Jdbi jdbi;
    private Handle handle;
    private Flyway flyway;
    private volatile boolean installPlugins;
    private Migration migration;

    protected abstract DataSource createDataSource();

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            this.lock.lock();
            try {
                if (this.dataSource == null) {
                    this.dataSource = this.createDataSource();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.dataSource;
    }

    public static JdbiRule embeddedPostgres() {
        return new EmbeddedPostgresJdbiRule();
    }

    public static JdbiRule embeddedPostgres(Consumer<EmbeddedPostgres.Builder> customizer) {
        return new EmbeddedPostgresJdbiRule(customizer);
    }

    public static JdbiRule externalPostgres(String hostname, Integer port, String username, String password, String database) {
        return new ExternalPostgresJdbiRule(hostname, port, username, password, database);
    }

    public static JdbiRule h2() {
        return new EmbeddedH2JdbiRule();
    }

    public static JdbiRule sqlite() {
        return new EmbeddedSqliteJdbiRule();
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    public JdbiRule migrateWithFlyway() {
        return this.migrateWithFlyway("db/migration");
    }

    @Deprecated(since="3.5.0", forRemoval=true)
    public JdbiRule migrateWithFlyway(String ... locations) {
        return this.withMigration(Migration.before().withPaths(locations));
    }

    public JdbiRule withMigration(Migration newMigration) {
        this.migration = newMigration;
        return this;
    }

    @Deprecated(forRemoval=true)
    public JdbiRule withPlugins() {
        this.installPlugins = true;
        return this;
    }

    public JdbiRule withPlugin(JdbiPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public void before() throws Throwable {
        if (this.migration != null) {
            this.flyway = Flyway.configure().dataSource(this.getDataSource()).locations(this.migration.paths.toArray(new String[0])).schemas(this.migration.schemas.toArray(new String[0])).cleanDisabled(!this.migration.cleanAfter).load();
            this.flyway.migrate();
        }
        this.jdbi = Jdbi.create((DataSource)this.getDataSource());
        if (this.installPlugins) {
            this.jdbi.installPlugins();
        }
        this.plugins.forEach(arg_0 -> ((Jdbi)this.jdbi).installPlugin(arg_0));
        this.handle = this.jdbi.open();
    }

    public void after() {
        if (this.flyway != null && this.migration.cleanAfter) {
            this.flyway.clean();
        }
        this.handle.close();
        this.jdbi = null;
        this.dataSource = null;
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public <T> T attach(Class<T> extension) {
        return (T)this.getHandle().attach(extension);
    }
}

