/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5.internal;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleListener;
import org.jdbi.v3.core.statement.Cleanable;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.StatementContextListener;
import org.junit.jupiter.api.Assertions;

public final class JdbiLeakChecker
implements StatementContextListener,
HandleListener {
    private final Map<StatementContext, RecordingContext<Cleanable>> contextElements = new ConcurrentHashMap<StatementContext, RecordingContext<Cleanable>>();
    private final RecordingContext<Handle> handleTracker = new RecordingContext();

    public void contextCreated(StatementContext statementContext) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Assertions.assertFalse((boolean)this.contextElements.containsKey(statementContext), (String)"statement context has already been created");
        this.contextElements.putIfAbsent(statementContext, new RecordingContext());
    }

    public void contextCleaned(StatementContext statementContext) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Assertions.assertTrue((boolean)this.contextElements.containsKey(statementContext), (String)"statement context is unknown");
        RecordingContext<Cleanable> context = this.contextElements.get(statementContext);
        Set leakedCleanables = this.difference(context.objectAdded.keySet(), context.objectRemoved.keySet());
        if (!leakedCleanables.isEmpty()) {
            Assertions.fail((String)String.format("Found %d cleanables that were not removed [%s]", leakedCleanables.size(), leakedCleanables));
        }
        context.reset();
    }

    public void cleanableAdded(StatementContext statementContext, Cleanable cleanable) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Objects.requireNonNull(cleanable, "cleanable is null");
        Assertions.assertTrue((boolean)this.contextElements.containsKey(statementContext), (String)"statement context is unknown");
        RecordingContext<Cleanable> context = this.contextElements.get(statementContext);
        Assertions.assertFalse((boolean)context.objectAdded.containsKey(cleanable), (String)"cleanable has already been added");
        Assertions.assertFalse((boolean)context.objectRemoved.containsKey(cleanable), (String)"cleanable has already been removed");
        context.objectAdded.putIfAbsent(cleanable, Boolean.TRUE);
    }

    public void cleanableRemoved(StatementContext statementContext, Cleanable cleanable) {
        Objects.requireNonNull(statementContext, "statementContext is null!");
        Objects.requireNonNull(cleanable, "cleanable is null");
        Assertions.assertTrue((boolean)this.contextElements.containsKey(statementContext), (String)"statement context is unknown");
        RecordingContext<Cleanable> context = this.contextElements.get(statementContext);
        Assertions.assertTrue((boolean)context.objectAdded.containsKey(cleanable), (String)"cleanable has not been added");
        Assertions.assertFalse((boolean)context.objectRemoved.containsKey(cleanable), (String)"cleanable has already been removed");
        context.objectRemoved.putIfAbsent(cleanable, Boolean.TRUE);
    }

    public void handleCreated(Handle handle) {
        Objects.requireNonNull(handle, "handle is null");
        Assertions.assertFalse((boolean)this.handleTracker.objectAdded.containsKey(handle), (String)"handle has already been added");
        Assertions.assertFalse((boolean)this.handleTracker.objectRemoved.containsKey(handle), (String)"handle has already been removed");
        this.handleTracker.objectAdded.putIfAbsent(handle, Boolean.TRUE);
    }

    public void handleClosed(Handle handle) {
        Objects.requireNonNull(handle, "handle is null");
        Assertions.assertTrue((boolean)this.handleTracker.objectAdded.containsKey(handle), (String)"handle has not been added");
        Assertions.assertFalse((boolean)this.handleTracker.objectRemoved.containsKey(handle), (String)"handle has already been removed");
        this.handleTracker.objectRemoved.putIfAbsent(handle, Boolean.TRUE);
    }

    public void checkForLeaks() {
        Set leakedHandles = this.difference(this.handleTracker.objectAdded.keySet(), this.handleTracker.objectRemoved.keySet());
        if (!leakedHandles.isEmpty()) {
            Assertions.fail((String)String.format("Found %d leaked handles.", leakedHandles.size()));
        }
        int leakedCleanablesCount = 0;
        for (RecordingContext<Cleanable> context : this.contextElements.values()) {
            Set leakedCleanables = this.difference(context.objectAdded.keySet(), context.objectRemoved.keySet());
            if (leakedCleanables.isEmpty()) continue;
            leakedCleanablesCount += leakedCleanables.size();
        }
        if (leakedCleanablesCount > 0) {
            Assertions.fail((String)String.format("Found %d leaked cleanable objects in %d contexts", leakedCleanablesCount, this.contextElements.size()));
        }
    }

    private <T> Set<T> difference(Set<T> left, Set<T> right) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T element : left) {
            if (right.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return 11 * super.hashCode();
    }

    private static final class RecordingContext<T> {
        private final Map<T, Boolean> objectAdded = new ConcurrentHashMap<T, Boolean>();
        private final Map<T, Boolean> objectRemoved = new ConcurrentHashMap<T, Boolean>();

        private RecordingContext() {
        }

        public void reset() {
            this.objectAdded.clear();
            this.objectRemoved.clear();
        }
    }
}

