/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing.junit5;

import de.softwareforge.testing.postgres.junit5.EmbeddedPgExtension;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleListener;
import org.jdbi.v3.core.Handles;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.config.ConfiguringPlugin;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContextListener;
import org.jdbi.v3.testing.junit5.JdbiExtensionInitializer;
import org.jdbi.v3.testing.junit5.JdbiExternalPostgresExtension;
import org.jdbi.v3.testing.junit5.JdbiH2Extension;
import org.jdbi.v3.testing.junit5.JdbiOtjPostgresExtension;
import org.jdbi.v3.testing.junit5.JdbiPostgresExtension;
import org.jdbi.v3.testing.junit5.JdbiSqliteExtension;
import org.jdbi.v3.testing.junit5.internal.JdbiLeakChecker;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;

public abstract class JdbiExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private final Set<JdbiPlugin> plugins = new LinkedHashSet<JdbiPlugin>();
    private final JdbiLeakChecker leakChecker = new JdbiLeakChecker();
    private Optional<JdbiExtensionInitializer> initializerMaybe = Optional.empty();
    private boolean installPlugins = false;
    private boolean enableLeakchecker = true;
    private volatile Jdbi jdbi;
    private volatile Handle sharedHandle;
    private volatile boolean dataSourceInitialized = false;
    private volatile DataSource dataSource;
    private static final Object JDBI_ID_KEY = new Object();
    private final ExtensionContext.Namespace jdbiNamespace = ExtensionContext.Namespace.create((Object[])new Object[]{UUID.randomUUID()});

    public static JdbiExtension postgres(EmbeddedPgExtension pg) {
        return JdbiPostgresExtension.instance(pg);
    }

    public static JdbiExtension externalPostgres(@NonNull String hostname, @Nullable Integer port, @NonNull String database, @Nullable String username, @Nullable String password) {
        return JdbiExternalPostgresExtension.instance(hostname, port, database, username, password);
    }

    public static JdbiOtjPostgresExtension otjEmbeddedPostgres() {
        return JdbiOtjPostgresExtension.instance();
    }

    public static JdbiExtension h2() {
        return JdbiH2Extension.instance();
    }

    public static JdbiExtension sqlite() {
        return JdbiSqliteExtension.instance();
    }

    protected JdbiExtension() {
    }

    public final Jdbi getJdbi() {
        if (this.jdbi == null) {
            throw new IllegalStateException("jdbi is null!");
        }
        return this.jdbi;
    }

    public abstract String getUrl();

    public final Handle getSharedHandle() {
        if (this.sharedHandle == null) {
            throw new IllegalStateException("sharedHandle is null!");
        }
        return this.sharedHandle;
    }

    public final JdbiExtension installPlugins() {
        this.installPlugins = true;
        return this;
    }

    public final JdbiExtension enableLeakChecker(boolean enable) {
        this.enableLeakchecker = enable;
        return this;
    }

    public final JdbiExtension withPlugin(JdbiPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public final JdbiExtension withPlugins(JdbiPlugin ... pluginList) {
        this.plugins.addAll(Arrays.asList(pluginList));
        return this;
    }

    public final JdbiExtension withInitializer(JdbiExtensionInitializer initializer) {
        if (initializer == null) {
            throw new IllegalStateException("initializer is null!");
        }
        if (this.initializerMaybe.isPresent()) {
            throw new IllegalStateException("initializer already defined!");
        }
        this.initializerMaybe = Optional.of(initializer);
        return this;
    }

    public final Handle openHandle() {
        return this.getJdbi().open();
    }

    public final <C extends JdbiConfig<C>> JdbiExtension withConfig(Class<C> configClass, Consumer<C> configurer) {
        return this.withPlugin((JdbiPlugin)ConfiguringPlugin.of(configClass, configurer));
    }

    public final <T> T attach(Class<T> extension) {
        return (T)this.getSharedHandle().attach(extension);
    }

    protected abstract DataSource createDataSource() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() throws Exception {
        if (!this.dataSourceInitialized) {
            JdbiExtension jdbiExtension = this;
            synchronized (jdbiExtension) {
                if (!this.dataSourceInitialized) {
                    DataSource ds;
                    this.dataSource = ds = this.createDataSource();
                    this.dataSourceInitialized = true;
                    return ds;
                }
            }
        }
        return this.dataSource;
    }

    protected void startExtension() throws Exception {
        if (this.jdbi != null || this.sharedHandle != null) {
            throw new IllegalStateException("Extension was already started!");
        }
        DataSource ds = this.getDataSource();
        if (this.enableLeakchecker) {
            this.withConfig(Handles.class, h -> h.addListener((HandleListener)this.leakChecker));
            this.withConfig(SqlStatements.class, s -> s.addContextListener((StatementContextListener)this.leakChecker));
        }
        Jdbi jdbiInstance = Jdbi.create((DataSource)ds);
        if (this.installPlugins) {
            jdbiInstance.installPlugins();
        }
        this.plugins.forEach(arg_0 -> ((Jdbi)jdbiInstance).installPlugin(arg_0));
        Handle sharedHandleInstance = jdbiInstance.open();
        this.jdbi = jdbiInstance;
        this.sharedHandle = sharedHandleInstance;
        this.initializerMaybe.ifPresent(i -> i.initialize(ds, sharedHandleInstance));
    }

    protected void stopExtension() throws Exception {
        if (this.jdbi == null || this.sharedHandle == null) {
            throw new IllegalStateException("Extension was already stopped!");
        }
        try {
            DataSource ds = this.getDataSource();
            Handle handle = this.sharedHandle;
            this.initializerMaybe.ifPresent(i -> i.cleanup(ds, this.sharedHandle));
            handle.close();
        }
        finally {
            this.dataSourceInitialized = false;
            this.dataSource = null;
            this.sharedHandle = null;
            this.jdbi = null;
            this.initializerMaybe = Optional.empty();
            this.plugins.clear();
        }
        if (this.enableLeakchecker) {
            this.leakChecker.checkForLeaks();
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.junit5Before(context);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.junit5Before(context);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.junit5After(context);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.junit5After(context);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return type == Jdbi.class || type == Handle.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        if (type == Jdbi.class) {
            return this.getJdbi();
        }
        if (type == Handle.class) {
            return this.getSharedHandle();
        }
        return null;
    }

    private void junit5Before(ExtensionContext extensionContext) throws Exception {
        String uniqueId;
        ExtensionContext.Store jdbiStore = extensionContext.getStore(this.jdbiNamespace);
        String extensionId = (String)jdbiStore.getOrComputeIfAbsent(JDBI_ID_KEY, arg_0 -> JdbiExtension.lambda$junit5Before$4(uniqueId = extensionContext.getUniqueId(), arg_0), String.class);
        if (extensionId.equals(uniqueId)) {
            this.startExtension();
        }
    }

    private void junit5After(ExtensionContext extensionContext) throws Exception {
        String uniqueId;
        ExtensionContext.Store jdbiStore = extensionContext.getStore(this.jdbiNamespace);
        String extensionId = (String)jdbiStore.getOrComputeIfAbsent(JDBI_ID_KEY, arg_0 -> JdbiExtension.lambda$junit5After$5(uniqueId = extensionContext.getUniqueId(), arg_0), String.class);
        if (extensionId.equals(uniqueId)) {
            this.stopExtension();
        }
    }

    private static /* synthetic */ String lambda$junit5After$5(String uniqueId, Object k) {
        return uniqueId;
    }

    private static /* synthetic */ String lambda$junit5Before$4(String uniqueId, Object k) {
        return uniqueId;
    }
}

