/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.h2.jdbcx.JdbcConnectionPool;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.testing.EmbeddedPostgresJdbiRule;
import org.junit.rules.ExternalResource;

public abstract class JdbiRule
extends ExternalResource {
    private volatile DataSource dataSource;
    private Jdbi jdbi;
    private Handle handle;
    private boolean installPlugins;
    private String[] migrationScriptPaths;
    private final List<JdbiPlugin> plugins = new ArrayList<JdbiPlugin>();
    private final Object mutex = new Object();

    protected abstract DataSource createDataSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSource() {
        if (this.dataSource == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.dataSource == null) {
                    this.dataSource = this.createDataSource();
                }
            }
        }
        return this.dataSource;
    }

    public static JdbiRule embeddedPostgres() {
        return new EmbeddedPostgresJdbiRule();
    }

    public static JdbiRule h2() {
        return new JdbiRule(){

            @Override
            protected DataSource createDataSource() {
                return JdbcConnectionPool.create((String)("jdbc:h2:mem:" + UUID.randomUUID()), (String)"", (String)"");
            }
        };
    }

    public JdbiRule migrateWithFlyway() {
        return this.migrateWithFlyway("db/migration");
    }

    public JdbiRule migrateWithFlyway(String ... locations) {
        this.migrationScriptPaths = locations;
        return this;
    }

    public JdbiRule withPlugins() {
        this.installPlugins = true;
        return this;
    }

    public JdbiRule withPlugin(JdbiPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    protected void before() throws Throwable {
        if (this.migrationScriptPaths != null) {
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.getDataSource());
            flyway.setLocations(this.migrationScriptPaths);
            flyway.migrate();
        }
        this.jdbi = Jdbi.create((DataSource)this.getDataSource());
        if (this.installPlugins) {
            this.jdbi.installPlugins();
        }
        this.plugins.forEach(arg_0 -> ((Jdbi)this.jdbi).installPlugin(arg_0));
        this.handle = this.jdbi.open();
    }

    protected void after() {
        this.handle.close();
        this.jdbi = null;
        this.dataSource = null;
    }

    public Jdbi getJdbi() {
        return this.jdbi;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public <T> T attach(Class<T> extension) {
        return (T)this.getHandle().attach(extension);
    }
}

