/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.extension.ExtensionContext;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.Handlers;
import org.jdbi.v3.sqlobject.SqlObject;

class WithHandleMethodHandlerFactory
implements HandlerFactory {
    private static final Method WITH_HANDLE = Handlers.methodLookup(SqlObject.class, "withHandle", HandleCallback.class);

    WithHandleMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
        if (!WITH_HANDLE.equals(method)) {
            return Optional.empty();
        }
        ExtensionMethod extensionMethod = new ExtensionMethod(sqlObjectType, method);
        return Optional.of((target, args, handleSupplier) -> {
            ExtensionContext extensionContext = new ExtensionContext(handleSupplier.getConfig(), extensionMethod);
            return handleSupplier.invokeInContext(extensionContext, () -> ((HandleCallback)args[0]).withHandle(handleSupplier.getHandle()));
        });
    }
}

