/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.jdbi.v3.core.internal.IterableLike;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface BindBeanList {
    public String value() default "";

    public String[] propertyNames();

    public static final class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Type type) {
            BindBeanList bindBeanList = (BindBeanList)annotation;
            String name = ParameterUtil.getParameterName(bindBeanList, bindBeanList.value(), param);
            return (stmt, arg) -> {
                if (arg == null) {
                    throw new IllegalArgumentException("argument is null; null was explicitly forbidden on BindBeanList");
                }
                stmt.bindBeanList(name, IterableLike.toList((Object)arg), Arrays.asList(bindBeanList.propertyNames()));
            };
        }
    }
}

