/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.sqlobject.DecoratorOrder;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;

public class SqlMethodAnnotatedHandlerDecorator
implements HandlerDecorator {
    @Override
    public Handler decorateHandler(Handler base, Class<?> sqlObjectType, Method method) {
        Handler handler = base;
        List annotationTypes = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlMethodDecoratingAnnotation.class)).collect(Collectors.toList());
        Stream.of(method, sqlObjectType).map(e -> e.getAnnotation(DecoratorOrder.class)).filter(Objects::nonNull).findFirst().ifPresent(order -> annotationTypes.sort(this.createDecoratorComparator((DecoratorOrder)order).reversed()));
        List decorators = annotationTypes.stream().map(type -> type.getAnnotation(SqlMethodDecoratingAnnotation.class)).map(a -> SqlMethodAnnotatedHandlerDecorator.buildDecorator(a.value())).collect(Collectors.toList());
        for (HandlerDecorator decorator : decorators) {
            handler = decorator.decorateHandler(handler, sqlObjectType, method);
        }
        return handler;
    }

    private Comparator<Class<? extends Annotation>> createDecoratorComparator(DecoratorOrder order) {
        List<Class<? extends Annotation>> ordering = Arrays.asList(order.value());
        return Comparator.comparingInt(type -> {
            int index = ordering.indexOf(type);
            return index == -1 ? ordering.size() : index;
        });
    }

    private static HandlerDecorator buildDecorator(Class<? extends HandlerDecorator> decoratorClass) {
        try {
            return decoratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Decorator class " + decoratorClass + "cannot be instantiated", e);
        }
    }
}

