/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.extension.ExtensionFactory;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.extension.HandleSupplier;
import org.jdbi.v3.sqlobject.DecoratorOrder;
import org.jdbi.v3.sqlobject.DefaultMethodHandler;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlMethodAnnotation;
import org.jdbi.v3.sqlobject.SqlMethodDecoratingAnnotation;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.Configurer;
import org.jdbi.v3.sqlobject.config.ConfiguringAnnotation;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

public class SqlObjectFactory
implements ExtensionFactory {
    private static final Object[] NO_ARGS = new Object[0];
    private final Map<Class<?>, Map<Method, Handler>> handlersCache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Class<? extends Configurer>, Configurer> configurers = Collections.synchronizedMap(new WeakHashMap());

    SqlObjectFactory() {
    }

    public boolean accepts(Class<?> extensionType) {
        if (!extensionType.isInterface()) {
            throw new IllegalArgumentException("SQL Objects are only supported for interfaces.");
        }
        if (!Modifier.isPublic(extensionType.getModifiers())) {
            throw new IllegalArgumentException("SQL Object types must be public.");
        }
        if (SqlObject.class.isAssignableFrom(extensionType)) {
            return true;
        }
        return Stream.of(extensionType.getMethods()).flatMap(m -> Stream.of(m.getAnnotations())).anyMatch(a -> a.annotationType().isAnnotationPresent(SqlMethodAnnotation.class));
    }

    public <E> E attach(Class<E> extensionType, HandleSupplier handle) {
        Map<Method, Handler> handlers = this.methodHandlersFor(extensionType);
        ConfigRegistry instanceConfig = handle.getConfig().createCopy();
        this.forEachConfigurer(extensionType, (configurer, annotation) -> configurer.configureForType(instanceConfig, (Annotation)annotation, extensionType));
        InvocationHandler invocationHandler = this.createInvocationHandler(extensionType, instanceConfig, handlers, handle);
        return extensionType.cast(Proxy.newProxyInstance(extensionType.getClassLoader(), new Class[]{extensionType}, invocationHandler));
    }

    private Map<Method, Handler> methodHandlersFor(Class<?> sqlObjectType) {
        return this.handlersCache.computeIfAbsent(sqlObjectType, type -> {
            HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> sqlObjectType.getName() + '@' + Integer.toHexString(t.hashCode()), Object.class, "toString", new Class[0]));
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> t == a[0], Object.class, "equals", Object.class));
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> System.identityHashCode(t), Object.class, "hashCode", new Class[0]));
            handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> h.getHandle(), SqlObject.class, "getHandle", new Class[0]));
            try {
                handlers.putAll(SqlObjectFactory.handlerEntry((t, a, h) -> null, sqlObjectType, "finalize", new Class[0]));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            for (Method method : sqlObjectType.getMethods()) {
                handlers.computeIfAbsent(method, m -> this.buildMethodHandler(sqlObjectType, (Method)m));
            }
            return handlers;
        });
    }

    private Handler buildMethodHandler(Class<?> sqlObjectType, Method method) {
        Handler handler = this.buildBaseHandler(sqlObjectType, method);
        return this.addDecorators(handler, sqlObjectType, method);
    }

    private Handler buildBaseHandler(Class<?> sqlObjectType, Method method) {
        List sqlMethodAnnotations = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlMethodAnnotation.class)).collect(Collectors.toList());
        if (sqlMethodAnnotations.size() > 1) {
            throw new IllegalStateException(String.format("Mutually exclusive annotations on method %s.%s: %s", sqlObjectType.getName(), method.getName(), sqlMethodAnnotations));
        }
        if (method.isDefault()) {
            if (!sqlMethodAnnotations.isEmpty()) {
                throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. SQL object methods may be default, or have a SQL method annotation, but not both.", sqlObjectType.getSimpleName(), method.getName(), ((Class)sqlMethodAnnotations.get(0)).getSimpleName()));
            }
            Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)).findFirst().ifPresent(type -> {
                throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. Statement customizing annotations don't work on default methods.", sqlObjectType.getSimpleName(), method.getName(), type.getSimpleName()));
            });
            for (Parameter parameter : method.getParameters()) {
                Stream.of(parameter.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)).findFirst().ifPresent(type -> {
                    throw new IllegalStateException(String.format("Default method %s.%s parameter %s has @%s annotation. Statement customizing annotations don't work on default methods.", sqlObjectType.getSimpleName(), method.getName(), parameter.getName(), type.getSimpleName()));
                });
            }
            return new DefaultMethodHandler(method);
        }
        return sqlMethodAnnotations.stream().map(type -> type.getAnnotation(SqlMethodAnnotation.class)).map(a -> SqlObjectFactory.buildFactory(a.value())).map(factory -> factory.buildHandler(sqlObjectType, method)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Method %s.%s must be default or be annotated with a SQL method annotation.", sqlObjectType.getSimpleName(), method.getName())));
    }

    private Handler addDecorators(Handler handler, Class<?> sqlObjectType, Method method) {
        List annotationTypes = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlMethodDecoratingAnnotation.class)).collect(Collectors.toList());
        Stream.of(method, sqlObjectType).map(e -> e.getAnnotation(DecoratorOrder.class)).filter(Objects::nonNull).findFirst().ifPresent(order -> annotationTypes.sort(this.createDecoratorComparator((DecoratorOrder)order).reversed()));
        List decorators = annotationTypes.stream().map(type -> type.getAnnotation(SqlMethodDecoratingAnnotation.class)).map(a -> SqlObjectFactory.buildDecorator(a.value())).collect(Collectors.toList());
        for (HandlerDecorator decorator : decorators) {
            handler = decorator.decorateHandler(handler, sqlObjectType, method);
        }
        return handler;
    }

    private Comparator<Class<? extends Annotation>> createDecoratorComparator(DecoratorOrder order) {
        List<Class<? extends Annotation>> ordering = Arrays.asList(order.value());
        ToIntFunction<Class> indexOf = type -> {
            int index = ordering.indexOf(type);
            return index == -1 ? ordering.size() : index;
        };
        return (l, r) -> indexOf.applyAsInt((Class)l) - indexOf.applyAsInt((Class)r);
    }

    private static HandlerFactory buildFactory(Class<? extends HandlerFactory> factoryClazz) {
        HandlerFactory factory;
        try {
            factory = factoryClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Factory class " + factoryClazz + "cannot be instantiated", e);
        }
        return factory;
    }

    private static HandlerDecorator buildDecorator(Class<? extends HandlerDecorator> decoratorClass) {
        HandlerDecorator decorator;
        try {
            decorator = decoratorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Decorator class " + decoratorClass + "cannot be instantiated", e);
        }
        return decorator;
    }

    private static Map<Method, Handler> handlerEntry(Handler handler, Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return Collections.singletonMap(klass.getMethod(methodName, parameterTypes), handler);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(String.format("can't find %s#%s%s", klass.getName(), methodName, Arrays.asList(parameterTypes)), e);
        }
    }

    private InvocationHandler createInvocationHandler(Class<?> sqlObjectType, ConfigRegistry instanceConfig, Map<Method, Handler> handlers, HandleSupplier handle) {
        return (proxy, method, args) -> {
            Handler handler = (Handler)handlers.get(method);
            ConfigRegistry methodConfig = instanceConfig.createCopy();
            this.forEachConfigurer(method, (configurer, annotation) -> configurer.configureForMethod(methodConfig, (Annotation)annotation, sqlObjectType, method));
            return handle.invokeInContext(new ExtensionMethod(sqlObjectType, method), methodConfig, () -> handler.invoke(proxy, args == null ? NO_ARGS : args, handle));
        };
    }

    private void forEachConfigurer(AnnotatedElement element, BiConsumer<Configurer, Annotation> consumer) {
        Stream.of(element.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ConfiguringAnnotation.class)).forEach(a -> {
            ConfiguringAnnotation meta = a.annotationType().getAnnotation(ConfiguringAnnotation.class);
            consumer.accept(this.getConfigurer(meta.value()), (Annotation)a);
        });
    }

    private Configurer getConfigurer(Class<? extends Configurer> factoryClass) {
        return this.configurers.computeIfAbsent(factoryClass, c -> {
            try {
                return (Configurer)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unable to instantiate configurer factory class " + factoryClass, e);
            }
        });
    }
}

