/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.statement.ResultReturner;
import org.jdbi.v3.sqlobject.statement.SqlObjectStatementConfiguration;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface UseRowMapper {
    public Class<? extends RowMapper<?>> value();

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class<?> sqlObjectType, Method method) {
            RowMapper<?> mapper;
            UseRowMapper mapperAnnotation = (UseRowMapper)annotation;
            try {
                mapper = mapperAnnotation.value().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnableToCreateStatementException("Could not create mapper " + mapperAnnotation.value().getName(), (Throwable)e, null);
            }
            ResultReturner returner = ResultReturner.forMethod(sqlObjectType, method);
            return q -> ((SqlObjectStatementConfiguration)q.getConfig(SqlObjectStatementConfiguration.class)).setReturner(() -> returner.result(((ResultBearing)q).map(mapper), q.getContext()));
        }
    }
}

