/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.statement;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizer;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;
import org.jdbi.v3.sqlobject.statement.ResultReturner;
import org.jdbi.v3.sqlobject.statement.SqlObjectStatementConfiguration;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
@SqlStatementCustomizingAnnotation(value=Factory.class)
public @interface MapTo {

    public static class Factory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, Parameter param, int index, Object arg) {
            Type type;
            if (arg instanceof GenericType) {
                type = ((GenericType)arg).getType();
            } else {
                if (!(arg instanceof Type)) {
                    throw new UnsupportedOperationException("@MapTo must take a Type, got a " + arg.getClass().getName());
                }
                type = (Type)arg;
            }
            return s -> {
                ResultReturner returner = ResultReturner.forMethod(sqlObjectType, method);
                ((SqlObjectStatementConfiguration)s.getConfig(SqlObjectStatementConfiguration.class)).setReturner(() -> returner.result(((ResultBearing)s).mapTo(type), s.getContext()));
            };
        }
    }
}

